clear all

base_url = 'https://api.fdic.gov/banks';


% Example: Get a list of all failed banks
failed_banks_url = [base_url,'/failures?filters=FAILYR%3A%5B%221980%22%20TO%20%222024%22%5D&fields=CERT&sort_by=FAILDATE&sort_order=DESC&limit=10000&offset=0&format=json'];

% Make the API request
response = webread(failed_banks_url);


nfailures = size(response.data,1);

asset_vec = nan(nfailures,1);
liab_vec = nan(nfailures,1);
cert_vec = nan(nfailures,1);
date_vec = cell(nfailures,1);

%%
for this_failure =1:nfailures

    this_cert = response.data(this_failure).data.CERT

    this_url = ['https://api.fdic.gov/banks/financials?filters=CERT%3A%20',num2str(this_cert),'&fields=CERT%2CREPDTE%2CASSET%2CLIAB%2CEQR%2C&sort_by=REPDTE&sort_order=DESC&limit=1&offset=0&format=json'];
        
    this_bank_financial = webread(this_url);
    
    if ~isempty(this_bank_financial.data)
    asset_vec(this_failure) = this_bank_financial.data.data.ASSET;
    liab_vec(this_failure) = this_bank_financial.data.data.LIAB;
    cert_vec(this_failure) = this_bank_financial.data.data.CERT;
    date_vec(this_failure) = cellstr(this_bank_financial.data.data.REPDTE);
    else
        cert_vec(this_failure) = this_cert;
    end
end

%%

financial_table = table(date_vec,cert_vec,asset_vec,liab_vec);

save fdic_failures financial_table


%% 
load fdic_failures

failure_table = readtable('bank-data_failure.xlsx');

merge_table = outerjoin(financial_table, failure_table, 'LeftKeys',"cert_vec",'RightKeys',"CERT");

nrows = size(merge_table,1);
date_num_vec = nan(nrows,1);
for this_row = 1:nrows
    if ~isempty(merge_table.date_vec{this_row})
        date_num_vec(this_row)=str2num(merge_table.date_vec{this_row});
    end
end

merge_table = [merge_table,table(date_num_vec)];

merge_table(isnan(merge_table.date_num_vec),:)=[];

merge_table.date_str_vec = num2str(merge_table.date_num_vec);

merge_table.quarter_vec = quarter(datetime(merge_table.date_str_vec,'Format','yyyyMMdd'));
merge_table.year_vec = year(datetime(merge_table.date_str_vec,'Format','yyyyMMdd'));

% downloaded from https://apps.bea.gov/iTable/?reqid=19&step=2&isuri=1&categories=underlying#eyJhcHBpZCI6MTksInN0ZXBzIjpbMSwyLDMsM10sImRhdGEiOltbImNhdGVnb3JpZXMiLCJTdXJ2ZXkiXSxbIk5JUEFfVGFibGVfTGlzdCIsIjIwMTMiXSxbIkZpcnN0X1llYXIiLCIxOTgwIl0sWyJMYXN0X1llYXIiLCIyMDI1Il0sWyJTY2FsZSIsIjAiXSxbIlNlcmllcyIsIlEiXV19
% Table 2.3.4U
PCEXFE = [36.67	37.49	38.325	39.259	40.129	40.888	41.641	42.381	43.002	43.584	44.282	44.899	45.489	45.837	46.533	46.905	47.379	47.934	48.384	48.728	49.393	49.821	50.333	50.694	51.241	51.592	51.947	52.37	52.701	53.213	53.69	54.236	54.758	55.422	56.061	56.687	57.306	57.827	58.258	58.791	59.468	60.132	60.74	61.25	61.793	62.27	62.83	63.325	63.809	64.26	64.64	65.114	65.563	66.061	66.43	66.772	67.075	67.526	67.903	68.248	68.606	69.013	69.342	69.69	69.964	70.296	70.617	71.019	71.298	71.67	71.837	72.065	72.277	72.498	72.756	72.987	73.171	73.425	73.695	74.042	74.43	74.689	75.05	75.421	75.912	76.199	76.395	76.764	77	77.424	77.836	78.113	78.354	78.651	79.011	79.365	79.801	80.258	80.545	80.982	81.558	81.962	82.281	82.831	83.311	83.975	84.427	84.791	85.376	85.731	86.152	86.747	87.207	87.573	88.02	87.95	87.95	88.294	88.607	89.159	89.464	89.706	89.843	90.127	90.523	91.053	91.468	91.794	92.373	92.755	93.023	93.435	93.799	94.064	94.434	94.842	95.141	95.557	95.915	96.175	96.336	96.765	97.077	97.319	97.726	98.262	98.689	99.028	99.488	99.821	100.123	100.568	101.208	101.751	102.076	102.552	102.964	103.398	103.783	104.147	104.59	104.386	105.177	105.651	106.539	108.083	109.385	110.811	112.466	113.795	115.247	116.577	117.931	119.05	119.744	120.346	121.458	122.296	122.961	123.764];
PCEXFE = transpose(PCEXFE);
date_vec_PCEXFE = transpose(1980:.25:2024.75);
% downloaded from https://fred.stlouisfed.org/series/CPILFESL 
% CPI-U excluding food and energy
CPIXFE = [77.600	80.200	81.400	83.933	85.900	87.800	90.767	92.533	93.667	95.400	97.000	97.333	97.933	98.900	100.133	101.433	102.833	104.100	105.400	106.467	107.633	108.767	109.733	111.000	112.200	113.133	114.200	115.300	116.233	117.633	118.733	120.100	121.267	122.733	124.100	125.600	126.933	128.300	129.533	131.100	132.767	134.500	136.500	138.067	140.067	141.333	142.867	144.200	145.467	146.733	147.867	149.200	150.500	151.767	152.667	153.867	154.867	155.933	157.100	158.100	159.433	160.733	161.800	162.933	164.033	165.000	166.067	167.133	168.100	169.167	169.900	170.867	171.900	172.867	173.900	174.867	175.633	176.467	177.400	178.400	179.567	180.700	181.900	183.000	184.333	185.467	186.733	187.967	189.000	189.967	190.967	191.833	192.467	192.800	193.567	194.067	195.000	196.233	197.067	198.267	199.500	200.433	201.100	202.433	203.700	205.367	206.767	207.833	209.051	210.066	211.149	212.635	214.043	214.973	216.357	216.887	217.797	218.907	219.560	220.683	220.716	220.993	221.528	222.107	223.157	224.200	225.733	226.937	228.130	229.251	230.287	231.360	232.531	233.059	234.305	235.346	236.257	237.479	238.462	239.411	240.246	241.699	242.899	244.185	245.459	247.076	248.365	249.514	250.803	251.468	252.444	253.895	255.729	257.058	257.986	259.473	261.173	262.318	263.848	265.513	267.047	265.669	268.248	269.876	270.882	275.564	279.129	283.427	288.033	292.174	296.648	300.377	303.968	307.468	309.740	312.345	315.569	317.997	319.869	322.534];
CPIXFE = transpose(CPIXFE);
date_vec_PCIXFE = transpose(1980:.25:2024.75);

year_vec = floor(date_vec_PCEXFE);
quarter_vec = (date_vec_PCEXFE-year_vec+.25)*4;
PCEXFE_table = table(PCEXFE,CPIXFE,year_vec,quarter_vec);

merge_table = outerjoin(merge_table,PCEXFE_table,'Keys',{'year_vec','quarter_vec'});

merge_table(isnan(merge_table.cert_vec),:)=[];

merge_table=merge_table(merge_table.year_vec_merge_table<2025,:);

equity2assets = (merge_table.asset_vec-merge_table.liab_vec)./merge_table.asset_vec;

real_assets = merge_table.asset_vec./merge_table.CPIXFE;

weights = real_assets./sum(real_assets);

sum(equity2assets.*weights)


% data_bank_h8.year = year(data_bank_h8.observation_date);
% data_bank_h8.quarter = quarter(data_bank_h8.observation_date);
% % Summary: The average (over months) of total assets for each quarter
% data_bank_h8_summary = groupsummary(data_bank_h8,["year" "quarter"],{"mean" "mean"},"TLAACBM027SBOG");
% % Merging data
% data_all_bank = outerjoin(data_failures_summary, data_bank_h8_summary, 'Keys',["year" "quarter"]);
