% This program replicates Figure 2 in "A Static Capital Buffer is 
% Hard to Beat" by Matthew Canzoneri, Behzad Diba, Luca Guerrieri 
% and Arsenii Mishin.
%
% The program produces Figure 2, corresponding to an increase in capital
% requirements, formatted as in the paper and another figure formatted for
% the slides.

clear all

setpath_windows

%global M_ oo_
global overwrite overwrite_param_names 

%overwrite_param_names = char('rho_gammap');
%overwrite = 0;

data_switch = 0;

simple_rule = 1;


nperiods = 60;
maxiter = 20;

%overwrite_param_names = 'r_dp';
%overwrite = 1/.99;

irfshock = char('eps_gamma');
shockssequence = 0.01;
% overwrite_param_names = char('gammap_increment','phip_i');
% overwrite = [0.001,100];


mod00 = 'model_safe_all_shocks';
mod11 = 'model_mixed_all_shocks';
mod10 = 'model_risky_all_shocks';
mod01 = 'model_spare_all_shocks';

constraint1 = 'chi2_upper_bar+chi2_upper_bar_ss<0';    % If the Lagrange multiplier on the
% no-shorting constraints for risky
% loans is slack, it means that I want
% to make risky loans.
% Accordingly, go into 11 or 10

constraint_relax1 = '((l+l_ss)<0)|(l_upper_bar<0)'; % If it turns out that the quantity of
% risky loans is negative,  00
% notice that l is set to 0 in the 10
% file, therefore the first condition
% is irrelevant when transition back
% from 10, but it might be relevant
% when transition back from 11.


constraint2 = '((chi2_lower_bar<0)&(l_upper_bar>0))'; % If the Lagrange multiplier on the
% no-shorting constraints for risky
% loans  and on safe loans are both slack, it means that I want
% to make risky and safe loans. Go to
% 01 or 11, but since if this
% condition is met constraint1 will
% also be active, we can only go into
% 11. Hence, 01 is spare.

constraint_relax2 ='((l+l_ss)<0)|(l_upper_bar<0)';  % return to 10 or 00, but
% notice that
% constraint_relax1 is identical,
% therefore, if either
% condition is violated
% we will go back to 00


% end of inputs
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if simple_rule
    [zdatalinear, zdatapiecewise, zdatass, oobase_, Mbase_, violvecbool ] = ...
        solve_two_constraints_add_violvecbool(mod00,mod10,mod01,mod11,...
        constraint1, constraint2,...
        constraint_relax1, constraint_relax2,...
        shockssequence,irfshock,nperiods,0,maxiter);
end




prefix1 = 's1_';
for this_var = 1:Mbase_.endo_nbr
    eval([prefix1,deblank(Mbase_.endo_names{this_var,:}),'_irf=zdatapiecewise(:,this_var);'])
    eval([prefix1,deblank(Mbase_.endo_names{this_var,:}),'_ss=zdatass(this_var);'])
end



%% plots
%
titlelist = char('Bank capital requirement','Deposits',...
    'Consumption', 'Total output',...
    'Loan Rate', 'Deposit rate' ,...
    'Total capital','Welfare');


line1 = 100*[ s1_gamma_var_irf, s1_d_irf/s1_d_ss,...
    10000*s1_c_irf/s1_c_ss,  10000*s1_ytot_irf/s1_ytot_ss,...
    1000*s1_r_l_irf, 1000*s1_r_d_irf,...
    10000*s1_ktot_irf/s1_ktot_ss, 1000*s1_welf_irf/abs(s1_welf_ss)];


percent = 'Percent';
ppt = 'Perc. Point';
ppt3 = 'Perc. Point, times 1000';
ppt4 = 'Perc. Point, times 10,000';
level = 'Level';
percent4= 'Percent, times 10,000';
percent3 = 'Percent, times 1000';
ylabels = char(ppt,percent,...
    percent4,percent4,...
    ppt3,ppt3,...
    ppt4,percent3);
figlabel = '';

legendlist = '';

makechart_no_scientific_notation(titlelist,legendlist,figlabel,ylabels,line1);


% Reordering the panels for the slides 
%reorder = [1 2 6 4 3 5];

%makechart_no_scientific_notation_slide(titlelist(reorder,:),legendlist,figlabel,ylabels(reorder,:),line1(:,reorder));


printpref;


