% This program replicates Figure 3 in "A Static Capital Buffer is 
% Hard to Beat" by Matthew Canzoneri, Behzad Diba, Luca Guerrieri 
% and Arsenii Mishin.
%
% The program produces Figure 3, corresponding to a comparison of an increase 
% and a decrease in capital requirements, formatted as in the paper and another 
% figure formatted for the slides.

clear all

setpath_windows

%global M_ oo_
global overwrite overwrite_param_names 


nperiods = 60;
maxiter = 200;

% select shock for IRFs
irfshock = char('eps_gamma');
shockssequence = 0.0095;      % set size of shock for the increase --- it will be reversed for the decrease keeping the same magnitude

% parameters changes 
%overwrite_param_names = 'gammap_increment';
%overwrite = [0.001];

mod00 = 'model_safe_all_shocks';
mod11 = 'model_mixed_all_shocks';
mod10 = 'model_risky_all_shocks';
mod01 = 'model_spare_all_shocks';


constraint1 = 'chi2_upper_bar+chi2_upper_bar_ss<0';    % If the Lagrange multiplier on the
% no-shorting constraints for risky
% loans is slack, it means that I want
% to make risky loans.
% Accordingly, go into 11 or 10

constraint_relax1 = '((l+l_ss)<0)|(l_upper_bar<0)'; % If it turns out that the quantity of
% risky loans is negative,  00
% notice that l is set to 0 in the 10
% file, therefore the first condition
% is irrelevant when transition back
% from 10, but it might be relevant
% when transition back from 11.


constraint2 = '((chi2_lower_bar<0)&(l_upper_bar>0))'; % If the Lagrange multiplier on the
% no-shorting constraints for risky
% loans  and on safe loans are both slack, it means that I want
% to make risky and safe loans. Go to
% 01 or 11, but since if this
% condition is met constraint1 will
% also be active, we can only go into
% 11. Hence, 01 is spare.

constraint_relax2 ='((l+l_ss)<0)|(l_upper_bar<0)';  % return to 10 or 00, but
% notice that
% constraint_relax1 is identical,
% therefore, if either
% condition is violated
% we will go back to 00


% end of inputs
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[zdatalinear, zdatapiecewise, zdatass, oobase_, Mbase_, violvecbool ] = ...
    solve_two_constraints_add_violvecbool(mod00,mod10,mod01,mod11,...
    constraint1, constraint2,...
    constraint_relax1, constraint_relax2,...
    shockssequence,irfshock,nperiods,0,maxiter);


% change sign of the shock and repeat the simulation
shockssequence = -shockssequence;
[zdatalinear2, zdatapiecewise2, zdatass, oobase_, Mbase_, violvecbool ] = ...
    solve_two_constraints_add_violvecbool(mod00,mod10,mod01,mod11,...
    constraint1, constraint2,...
    constraint_relax1, constraint_relax2,...
    shockssequence,irfshock,nperiods,0,maxiter);



prefix1 = 's1_';
prefix2 = 's2_';
for this_var = 1:Mbase_.endo_nbr
    eval([prefix1,deblank(Mbase_.endo_names{this_var,:}),'_irf=zdatapiecewise(:,this_var);'])
    eval([prefix1,deblank(Mbase_.endo_names{this_var,:}),'_ss=zdatass(this_var);'])
    
    eval([prefix2,deblank(Mbase_.endo_names{this_var,:}),'_irf=zdatapiecewise2(:,this_var);'])
    eval([prefix2,deblank(Mbase_.endo_names{this_var,:}),'_ss=zdatass(this_var);'])
    
end



%% Plots

spread_title = 'Expected equity return spread';
spread_title = [spread_title newline '(risky-safe)'];

titlelist = char('Bank capital requirement','Total deposits',...
    'Consumption', 'Total output',...
    spread_title, 'Welfare');


line1 = 100*[ s1_gamma_var_irf, (s1_d_irf+s1_d_upper_bar_irf)/(s1_d_ss+s1_d_upper_bar_ss),...
    s1_c_irf/s1_c_ss,  s1_ytot_irf/s1_ytot_ss,...
    [s1_r_e_upper_bar_irf(2:end)+s1_r_e_upper_bar_ss-s1_r_e_irf(2:end)-s1_r_e_ss; nan], s1_welf_irf/abs(s1_welf_ss)];


line2 = 100*[ s2_gamma_var_irf, (s2_d_irf+s2_d_upper_bar_irf)/(s2_d_ss+s2_d_upper_bar_ss),...
    s2_c_irf/s2_c_ss,  s2_ytot_irf/s2_ytot_ss,...
    [s2_r_e_upper_bar_irf(2:end)+s2_r_e_upper_bar_ss-s2_r_e_irf(2:end)-s2_r_e_ss; nan], s2_welf_irf/abs(s2_welf_ss)];


percent = 'Percent';
ppt = 'Perc. Point';
level = 'Level';
ylabels = char(ppt,percent,...
    percent,percent,...
    ppt,percent);
figlabel = '';



legendlist  = char('Higher capital requirements','Lower capital requirements');
[~, legend_handle]=makechart(titlelist,legendlist,figlabel,ylabels,line1,line2);
set(legend_handle,'Location','northeast')

% make figure for slides
%reorder = [1 2 6 4 3 5];

%makechart_slide(titlelist(reorder,:),legendlist,figlabel,ylabels(reorder,:),line1(:,reorder),line2(:,reorder));










