clear all
setpath_windows 


global overwrite overwrite_param_names


model_safe_paramfile_opt_spreads

gamma_var_opt = gamma_var;
welf_opt = welf;

model_safe_paramfile_spreads

r_dp

gamma_var

gamma_buffer = gamma_var-gamma_var_opt;

step = 0.0005;
increment_grid_up = gamma_var_opt:step:.15; 
npoints = length(increment_grid_up);

welf_up = nan(npoints,1);
gamma_var_up = nan(npoints,1);
%overwrite_param_names = 'gammap_increment';

for this_point = 1:npoints
    %overwrite = increment_grid_up(this_point);
    
    
    [welf_up(this_point), gamma_var_up(this_point),...
        c_up(this_point), d_up(this_point), ...
        sigmap_zero_up(this_point),...
     ktot_up(this_point), r_e_upper_bar_up(this_point), ...
     r_e_up(this_point), k_r_up(this_point), k_up(this_point),...
     r_d_up(this_point),Tax_level_up(this_point),f_costs_up(this_point)] = ...
        param_steady_state_welf_check_safe(increment_grid_up(this_point));

end

clear overwrite overwrite_param_names;

grid_down = 0.03:step:gamma_var_opt-step;
npoints = length(grid_down);
welf_down = nan(npoints,1);
gamma_var_down = nan(npoints,1);

for this_point = 1:npoints
    [welf_down(this_point), gamma_var_down(this_point),...
        c_down(this_point), d_down(this_point),...
        sigmap_zero_down(this_point),...
     ktot_down(this_point), r_e_upper_bar_down(this_point), ...
     r_e_down(this_point), k_r_down(this_point), k_down(this_point),...
     r_d_down(this_point), Tax_level_down(this_point) ...
     diff_down(this_point), f_costs_down(this_point)] =...
    param_steady_state_welf_check_risky(grid_down(this_point));

end


welf_grid = [welf_down; welf_up];
gamma_var_grid = [gamma_var_down; gamma_var_up];

%%
figure

subplot(1,2,1)
plot(gamma_var_down*100,welf_down)
title('Welfare, risky regime')
xlabel('Capital requirement, percent')
h=ylim;
subplot(1,2,2)
plot(gamma_var_up*100, welf_up)
title('Welfare, safe regime')
%ylim(h);
xlabel('Capital requirement, percent')
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])

%%

figure
subplot(4,2,1); plot(gamma_var_down*100,c_down)
title('Consumption, risky regime')
h=ylim;
subplot(4,2,2); plot(gamma_var_up*100,c_up)
title('Consumption, safe regime')
ylim(h)
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])


subplot(4,2,3); plot(gamma_var_down*100,ktot_down)
title('Total Capital, risky regime')
h=ylim;
ylim([0 h(2)])

subplot(4,2,4); plot(gamma_var_up*100,ktot_up)
title('Total Capital, safe regime')
ylim([0 h(2)])
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])

subplot(4,2,5); plot(gamma_var_down*100,k_down)
title('Safe Capital, risky regime')
ylim([0 20])

subplot(4,2,6); plot(gamma_var_up*100,k_up)
title('Safe Capital, safe regime')
ylim([0 20])
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])

subplot(4,2,7); plot(gamma_var_down*100,k_r_down)
title('Risky Capital, risky regime')
h=ylim;
ylim([0 h(2)])
xlabel('Capital requirement, percent')

subplot(4,2,8); plot(gamma_var_up*100,k_r_up)
title('Risky Capital, safe regime')
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])
ylim([0 h(2)])
xlabel('Capital requirement, percent')


figure

subplot(3,2,1)
plot(gamma_var_down*100,r_e_upper_bar_down)
title('Return on equity risky banks, risky regime')
ylim([0 1.5])

subplot(3,2,2)
plot(gamma_var_up*100,r_e_upper_bar_up)
title('Return on equity risky banks, safe regime')
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])
ylim([0 1.5])

subplot(3,2,3)
plot(gamma_var_down*100,r_e_down)
title('Return on equity safe banks, risky regime')
ylim([0 1.5])

subplot(3,2,4)
plot(gamma_var_up*100,r_e_up)
title('Return on equity safe banks, safe regime')
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])
ylim([0 1.5])

subplot(3,2,5)
plot(gamma_var_down*100,Tax_level_down)
title('Tax for deposit insurance, risky regime')


subplot(3,2,6)
plot(gamma_var_up*100,Tax_level_up)
title('Tax for deposit insurance, safe regime')
xlim([gamma_var_up(1)*100 gamma_var_up(end)*100])

%%

figure

subplot(4,1,1)
plot(gamma_var_down*100,welf_down,'k','LineWidth',1.5); hold on
plot(gamma_var_up*100, welf_up,'k','LineWidth',1.5)
hhh = vline(gamma_var_opt*100,'r--','Border of risky and safe regimes');
set(hhh,'LineWidth',1.5)
title('Welfare')
ylabel('Level')
xlim([gamma_var_down(1)*100 gamma_var_up(end)*100])

subplot(4,1,2)
plot(gamma_var_down*100,c_down,'k','LineWidth',1.5); hold on
plot(gamma_var_up*100,c_up,'k','LineWidth',1.5)
title('Consumption')
hhh = vline(gamma_var_opt*100,'r--');
set(hhh,'LineWidth',1.5)
ylabel('Level')
xlim([gamma_var_down(1)*100 gamma_var_up(end)*100])

subplot(4,1,3)
plot(gamma_var_down*100,ktot_down,'k','LineWidth',1.5); hold on
plot(gamma_var_up*100,ktot_up,'k','LineWidth',1.5)
title('Capital')
hhh = vline(gamma_var_opt*100,'r--');
set(hhh,'LineWidth',1.5)
ylabel('Level')
xlim([gamma_var_down(1)*100 gamma_var_up(end)*100])

subplot(4,1,4)
plot(gamma_var_down*100,d_down,'k','LineWidth',1.5); hold on
plot(gamma_var_up*100,d_up,'k','LineWidth',1.5)
title('Deposits')
hhh = vline(gamma_var_opt*100,'r--');
set(hhh,'LineWidth',1.5)
ylabel('Level')
xlim([gamma_var_down(1)*100 gamma_var_up(end)*100])
xlabel('Capital requirement, percent')
printpref

print -depsc2 figure_steady_state_capital.eps
%%

% figure
% subplot(2,1,1)
% plot(gamma_var_down,diff_down)
% 
% subplot(2,1,2)
% plot([gamma_var_down',gamma_var_up']*100,[f_costs_down,f_costs_up])