function [model_momm,...
          mean_negative_equity_at_default,...
          average_failure_rate,...
          average_gdp_loss,...
          max_failure_rate,...
          crisis_prob]=make_moments(M00_,zdatapiecewise_,zdatass_)

        % ytot_pos = find(strcmp('ytot',M00_.endo_names));
        % ginvest_pos = find(strcmp('ginvest',M00_.endo_names));
        % q_pos = find(strcmp('q',M00_.endo_names));
        % c_pos = find(strcmp('c',M00_.endo_names));
        % non_defaulted_pos = find(strcmp('non_defaulted',M00_.endo_names));
        % excess_risk_switch_pos = strcmp('excess_risk_switch',M00_.endo_names));
        % Tax_pos = find(strcmp('Tax',M00_.endo_names));
        % ltot_pos = find(strcmp('ltot',M00_.endo_names));


        f0_ytot_data = zdatapiecewise_(:,strcmp('ytot',M00_.endo_names));
        f0_ginvest_data = zdatapiecewise_(:,strcmp('ginvest',M00_.endo_names));
        f0_q_data = zdatapiecewise_(:,strcmp('q',M00_.endo_names));
        f0_non_defaulted_data = zdatapiecewise_(:,strcmp('non_defaulted',M00_.endo_names));
        f0_excess_risk_switch = zdatapiecewise_(:,strcmp('excess_risk_switch',M00_.endo_names));
        f0_Tax_data = zdatapiecewise_(:,strcmp('Tax',M00_.endo_names));
        f0_ltot_data = zdatapiecewise_(:,strcmp('ltot',M00_.endo_names));

        f0_ytot_ss = zdatass_(strcmp('ytot',M00_.endo_names));
        f0_ginvest_ss = zdatass_(strcmp('ginvest',M00_.endo_names));
        f0_non_defaulted_ss = zdatass_(strcmp('non_defaulted',M00_.endo_names));
        f0_ltot_ss = zdatass_(strcmp('ltot',M00_.endo_names));
        
        gdp = 100*bpass(f0_ytot_data/f0_ytot_ss,6,32);
        investment = 100*bpass(f0_ginvest_data/f0_ginvest_ss,6,32);
        investment_price = 100*bpass(f0_q_data,6,32);

       
        model_dataset = [gdp, investment, investment_price];


        optwt = 0; % no weighting function computed
        [model_momm] = wtm_rm_noskew_opt(model_dataset,optwt);
        
        
        ltot_lag = [f0_ltot_ss; f0_ltot_data(1:end-1)+f0_ltot_ss];
        f0_non_defaulted = f0_non_defaulted_data+1;
        myone = 0.999999999;
        mean_negative_equity_at_default = mean(...
                f0_Tax_data(f0_non_defaulted<myone).*...
                (f0_ytot_data(f0_non_defaulted<myone)+f0_ytot_ss)./...
                (  ltot_lag(f0_non_defaulted<myone) .* (1 - f0_non_defaulted(f0_non_defaulted<myone)) ) ...
            );

        average_failure_rate = (1 - mean(f0_non_defaulted_ss+f0_non_defaulted_data));
        
        max_failure_rate = 4*max(1 - (f0_non_defaulted_ss+f0_non_defaulted_data));

        average_gdp_loss = sum(gdp(f0_excess_risk_switch>0.00001))/sum(f0_excess_risk_switch>0.00001); 

        crisis_prob = length(find(f0_non_defaulted<0.99))/length(f0_non_defaulted);
        