// Endogenous variables
var c, lambda_c, ds, r_d, r_l, w, y, h, k, ginvest, ninvest, l, e, h_r, k_r,
    y_r, r_lr, Tax, r_l_lead,  k_r_lag, sigma, ytot, q, tot_ret, ktot, 
    profits, expected_dividend, expected_dividend_upper_bar,
    excess_risk_switch, gamma_var, Util1, Util2,  epsilon_star, epsilon_star_expected,
    non_defaulted, non_defaulted_expected, return_non_defaulted, return_non_defaulted_expected,
    omega_1, omega_1_expected, omega_2, omega_2_expected, e_upper_bar, l_upper_bar, d, d_upper_bar,
    chi2_lower_bar, chi2_upper_bar, mu_lower_bar, mu_upper_bar, r_e, r_e_upper_bar, dummy_instr, 
    tau_var, kap_quality, isp,  ltot, ltot2ytot, banking_spread, welf, utilc, welfc;

// Exogenous variables
var a, a_lag;

varexo eps_a, eps_tau, eps_kap_quality, eps_gamma, eps_isp;

parameters 
sigmap_c, sigmap_zero, sigmap_d, gammap, rho_gammap, betap, alphap, deltap, 
rhop_a, xip, sigma_bar, sigma_eps_a, r_l_ss, r_d_ss, d_ss, l_ss, c_ss,
ltot2ytot_ss, expected_dividend_ss, k_ss, invest_ss, banking_spread_ss, ytot_ss,
sigma_lower_bar, pip, taup, kappap, phip_i, recovery_ratiop, rl_rd_spreadp,
f_costs, kappab, profits_ss, r_l_subsidyp, rho_taup, rho_kap_quality, chi2_upper_bar_ss,
rho_isp, sigma_eps_isp, sigma_eps_tau, sigma_eps_kap_quality,
q_gammap, ltot2ytot_gammap, r_d_gammap, r_l_lead_gammap, banking_spread_gammap, 
ytot_gammap, a_gammap, isp_gammap, tau_gammap, eps_a_gammap, eps_isp_gammap, eps_tau_gammap, 
k_gammap, d_gammap, c_gammap, ginvest_gammap, l_gammap, chi2_upper_bar_gammap, zerop;



model;

/////////////////
// Policy bloc
/////////////////

gamma_var = gammap + rho_gammap *(gamma_var(-1)-gammap) 
                   + q_gammap*(q(-1)-1) 
                   + ltot2ytot_gammap*(ltot2ytot-ltot2ytot_ss)
                   + r_d_gammap*(r_d(-1)-r_d_ss) + r_l_lead_gammap*(r_l_lead-r_l_ss)
                   + banking_spread_gammap * (banking_spread-banking_spread_ss) 
                   + ytot_gammap*(ytot-ytot_ss)
                   + eps_a_gammap*eps_a
                   + a_gammap * (a-1)
                   + eps_isp_gammap*eps_isp
                   + isp_gammap *(isp-1)
                   + eps_tau_gammap*eps_tau
                   + tau_gammap * (tau_var-taup)
                   + k_gammap *(k(-1)-k_ss)
                   + d_gammap *(d(-1)-d_ss)                   
                   + c_gammap *(c(-1)-c_ss)
                   + ginvest_gammap *(ginvest(-1)-invest_ss)
                   + l_gammap *(l(-1)-l_ss)
                   + chi2_upper_bar_gammap*(chi2_upper_bar - chi2_upper_bar_ss)
                   + eps_gamma;



// Policy Rule, agent 2
dummy_instr = dummy_instr(-1);


/////////////////////////
// Structural equations
/////////////////////////

// Households
// 3. Marginal utility of consumption
(c-kappap*c(-1))^(-sigmap_c)-betap*kappap*(c(1)-kappap*c)^(-sigmap_c) - lambda_c = 0;

// 4. Euler equation for d
sigmap_zero*(ds^(-sigmap_d)) - lambda_c + betap*lambda_c(1)*r_d=0;


// Banks

// 5. FOC that picks up chi2_upper_bar -- changes for risky branch to:
//(1+kappab)*gamma_var - chi2_upper_bar = betap*lambda_c(1)/lambda_c*( sigma_bar/q*tau_var/sqrt(2*pip)
//            *exp(-(  ( f_costs*q+r_d*(1-gamma_var)*q-r_l(1)*(1-sigma_bar+sigma_bar/kap_quality(1))*q+xip*sigma_bar)/
//                        (sigma_bar*sqrt(2)*tau_var) 
//                   )^2 
//                 )
//             + 0.5*( r_l(1)*(1-sigma_bar+sigma_bar/kap_quality(1))-sigma_bar*xip/q-(1-gamma_var)*r_d-f_costs )
//                  *(1-erf( ( f_costs*q+r_d*(1-gamma_var)*q-r_l(1)*(1-sigma_bar+sigma_bar/kap_quality(1))*q+xip*sigma_bar )/
//                        (sigma_bar*sqrt(2)*tau_var) 
//                         )  
//                    )
//           );


//5 FOC becomes reduntant: define R_e on safe banks -- changes for risky branch to:
r_e*gamma_var(-1)= ( sigma_lower_bar/q(-1)*tau_var(-1)/sqrt(2*pip)
            *exp(-(  ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*q(-1)+xip*sigma_lower_bar)/
                        (sigma_lower_bar*sqrt(2)*tau_var(-1)) 
                   )^2 
                 )
            + 0.5*( r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)-sigma_lower_bar*xip/q(-1)-(1-gamma_var(-1))*r_d(-1)-f_costs )
                  *(1-erf( ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*q(-1)+xip*sigma_lower_bar )/
                        (sigma_lower_bar*sqrt(2)*tau_var(-1)) 
                         )  
                    )
           );


        
// Firms
// 6. Demand for labor using safe technology
w = (1-alphap)*a*((kap_quality*k(-1)/h)^alphap);

// 7. Demand for labor using risky technology
w = (1-alphap)*a*(k_r(-1)^alphap)*(h_r^(-alphap));

// 8. Demand for safe loans
alphap*a*kap_quality*((k(-1)/h)^(alphap-1))/q(-1) + (1-deltap)*q*kap_quality/q(-1) = r_l*(1-r_l_subsidyp);

// 9. Demand for risky loans
r_l*(1-r_l_subsidyp)/kap_quality-xip/q(-1) = r_lr;

// 10. Safe technology Production Function
y = a*((kap_quality*k(-1))^alphap) *(h^(1-alphap));

// 11. Risky technology Production Function
y_r = a*((k_r(-1))^alphap)*(h_r^(1-alphap)) + 0.5*k_r(-1) - 0.5*(1 + 2*xip)*k_r(-1);

// 12. Investment
k + k_r = (1-deltap)*(kap_quality*k(-1) + k_r(-1)) + ninvest;

// Equilibrium
// 13. Labor market 
h + h_r = 1;

// 14. Goods market
y + y_r = c + ginvest +kappab*(e+e_upper_bar);

// 15. Binding Capital Requirement
e = gamma_var*l;

// 16. Binding Capital Requirement
e_upper_bar = gamma_var*l_upper_bar;

// 17. Loanable Funds -- changes for mixed branch to:
(k + k_r)*q = l+l_upper_bar;

// 18. Share of risky capital -- changes for mixed branch to:
sigma =k_r/(k_r+k);
//sigma = sigma_lower_bar;

// 19. Risky capital  -- changes for mixed branch
k_r*q = sigma_lower_bar*l+sigma_bar*l_upper_bar;

// 20. Balance sheet
l = e+d;

// 21.b. Balance sheet
l_upper_bar = e_upper_bar+d_upper_bar;

// 22. Tax -- changes for risky branch to:
Tax = -( -sigma_lower_bar*l(-1)/q(-1)*tau_var(-1)/sqrt(2*pip)
            *exp(-(  ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*q(-1)+xip*sigma_lower_bar )/
                        (sigma_lower_bar*sqrt(2)*tau_var(-1))
                   )^2 
                 )
             + 0.5*( r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*l(-1)-r_d(-1)*d(-1)-sigma_lower_bar*l(-1)*xip/q(-1)-f_costs*l(-1) )
                  *(1+erf( ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*q(-1)+xip*sigma_lower_bar )/
                        (sigma_lower_bar*sqrt(2)*tau_var(-1))
                         )  
                    )
           )/ytot
    -( -sigma_bar*l_upper_bar(-1)/q(-1)*tau_var(-1)/sqrt(2*pip)
            *exp(-(  ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_bar+sigma_bar/kap_quality)*q(-1)+xip*sigma_bar )/
                        (sigma_bar*sqrt(2)*tau_var(-1))
                   )^2 
                 )
             + 0.5*( r_l*(1-sigma_bar+sigma_bar/kap_quality)*l_upper_bar(-1)-r_d(-1)*d_upper_bar(-1)-sigma_bar*l_upper_bar(-1)*xip/q(-1)-f_costs*l_upper_bar(-1))
                  *(1+erf( ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_bar+sigma_bar/kap_quality)*q(-1)+xip*sigma_bar )/
                        (sigma_bar*sqrt(2)*tau_var(-1))
                        )  
                  )
         )/ytot;




// 23
r_l_lead = r_l(1);



// 24
k_r_lag = k_r(-1);


// 25 total output
ytot = y+y_r;

// 26
ktot = k+k_r;

// 27
tot_ret = r_l*k(-1)+r_lr*k_r(-1);

// 28 -- changes for risky branch to:
profits = ((sigma_lower_bar*l(-1)/q(-1)*tau_var(-1)/sqrt(2*pip)
            *exp(-(  ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*q(-1)+xip*sigma_lower_bar )/
                        (sigma_lower_bar*sqrt(2)*tau_var(-1))
                   )^2 
                 )
             + 0.5*( r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*l(-1)-r_d(-1)*d(-1)-sigma_lower_bar*l(-1)*xip/q(-1)-f_costs*l(-1) )
                  *(1-erf( ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality)*q(-1)+xip*sigma_lower_bar )/
                        (sigma_lower_bar*sqrt(2)*tau_var(-1))
                         )  
                    )
            )-(1+kappab)*e)
            +
           ((sigma_bar*l_upper_bar(-1)/q(-1)*tau_var(-1)/sqrt(2*pip)
            *exp(-(  ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_bar+sigma_bar/kap_quality)*q(-1)+xip*sigma_bar )/
                        (sigma_bar*sqrt(2)*tau_var(-1))
                   )^2 
                 )
             + 0.5*( r_l*(1-sigma_bar+sigma_bar/kap_quality)*l_upper_bar(-1)-r_d(-1)*d_upper_bar(-1)-sigma_bar*l_upper_bar(-1)*xip/q(-1)-f_costs*l_upper_bar(-1) )
                  *(1-erf( ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_bar+sigma_bar/kap_quality)*q(-1)+xip*sigma_bar )/
                        (sigma_bar*sqrt(2)*tau_var(-1))
                         )  
                    )
            )-(1+kappab)*e_upper_bar);


// 29
expected_dividend = ( sigma_lower_bar*l/q*tau_var/sqrt(2*pip)
            *exp(-(  ( f_costs*q+r_d*(1-gamma_var)*q-r_l(1)*(1-sigma_lower_bar+sigma_lower_bar/kap_quality(1))*q+xip*sigma_lower_bar )/
                        (sigma_lower_bar*sqrt(2)*tau_var)
                   )^2 
                 )
             + 0.5*( r_l(1)*(1-sigma_lower_bar+sigma_lower_bar/kap_quality(1))*l-r_d*d-sigma_lower_bar*l*xip/q-f_costs*l)
                  *(1-erf( ( f_costs*q+r_d*(1-gamma_var)*q-r_l(1)*(1-sigma_lower_bar+sigma_lower_bar/kap_quality(1))*q+xip*sigma_lower_bar )/
                        (sigma_lower_bar*sqrt(2)*tau_var)
                         )  
                    )
                                      );

// 30.b.
expected_dividend_upper_bar = ( sigma_bar*l_upper_bar/q*tau_var/sqrt(2*pip)
            *exp(-(  ( f_costs*q+r_d*(1-gamma_var)*q-r_l(1)*(1-sigma_bar+sigma_bar/kap_quality(1))*q+xip*sigma_bar )/
                        (sigma_bar*sqrt(2)*tau_var)
                   )^2 
                 )
             + 0.5*( r_l(1)*(1-sigma_bar+sigma_bar/kap_quality(1))*l_upper_bar-r_d*d_upper_bar-sigma_bar*l_upper_bar*xip/q-f_costs*l_upper_bar)
                  *(1-erf( ( f_costs*q+r_d*(1-gamma_var)*q-r_l(1)*(1-sigma_bar+sigma_bar/kap_quality(1))*q+xip*sigma_bar )/
                       (sigma_bar*sqrt(2)*tau_var)
                         )  
                    )
                                      );

// 31
excess_risk_switch = (sigma-sigma_lower_bar)/(sigma_bar-sigma_lower_bar)+zerop*excess_risk_switch(-1);

// 32
ninvest  = isp*(1-phip_i/2*(ginvest/ginvest(-1)-1)^2)*ginvest;

// 44
q*(1-phip_i/2*(ginvest/ginvest(-1)-1)^2)*isp
-q*phip_i*(ginvest/ginvest(-1)-1)*ginvest/ginvest(-1)*isp=1
   -betap*lambda_c(1)/lambda_c*q(1)*phip_i*(ginvest(1)/ginvest-1)*ginvest(1)^2/ginvest^2*isp(1);

// 45
epsilon_star = (1-excess_risk_switch(-1))
               *(f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality))*q(-1)/sigma_lower_bar
               + excess_risk_switch(-1)
               *(f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_bar+sigma_bar/kap_quality))*q(-1)/sigma_bar;

// 46   //change sigma
epsilon_star_expected = epsilon_star(1);

// 47
non_defaulted = (1-excess_risk_switch(-1))
                *(0.5 - 0.5*erf((((f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality))
                *q(-1)/sigma_lower_bar)+xip)/(tau_var(-1)*sqrt(2))))
                + excess_risk_switch(-1)
                *(0.5 - 0.5*erf((((f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_bar+sigma_bar/kap_quality))
                *q(-1)/sigma_bar)+xip)/(tau_var(-1)*sqrt(2))));

// 48   //change sigma
non_defaulted_expected = non_defaulted(1);

// 49   
return_non_defaulted = (1-excess_risk_switch(-1))
                       *(r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality) - r_d(-1)
                       *(1-gamma_var(-1)) - xip*sigma_lower_bar/q(-1) - f_costs)
                       + excess_risk_switch(-1)
                       *(r_l*(1-sigma_bar+sigma_bar/kap_quality) - r_d(-1)
                       *(1-gamma_var(-1)) - xip*sigma_bar/q(-1) - f_costs);

// 50   //change sigma
return_non_defaulted_expected = return_non_defaulted(1);

// 51
omega_1 = (r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality) - r_d(-1)*(1-gamma_var(-1))-f_costs-xip*sigma_lower_bar/q(-1))*l(-1)*
          (0.5 - 0.5*erf((((f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality))
          *q(-1)/sigma_lower_bar)+xip)/(tau_var(-1)*sqrt(2))))
          + (r_l*(1-sigma_bar+sigma_bar/kap_quality) - r_d(-1)*(1-gamma_var(-1))-f_costs-xip*sigma_bar/q(-1))*l_upper_bar(-1)*
          (0.5 - 0.5*erf((((f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_bar+sigma_bar/kap_quality))
          *q(-1)/sigma_bar)+xip)/(tau_var(-1)*sqrt(2))));

// 52   //change sigma
omega_1_expected = omega_1(1);

// 53
omega_2 = sigma_lower_bar*tau_var(-1)/sqrt(2*pip)/q(-1)*l(-1)*
          exp(-(((((f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_lower_bar+sigma_lower_bar/kap_quality))
          *q(-1)/sigma_lower_bar)+xip)/(tau_var(-1)*sqrt(2)))^2))
          + sigma_bar*tau_var(-1)/sqrt(2*pip)/q(-1)*l_upper_bar(-1)*
          exp(-(((((f_costs+r_d(-1)*(1-gamma_var(-1))-r_l*(1-sigma_bar+sigma_bar/kap_quality))
          *q(-1)/sigma_bar)+xip)/(tau_var(-1)*sqrt(2)))^2));

// 54   //change sigma
omega_2_expected = omega_2(1);


// 56 market clearing for deposits -- changes for mixed branch to:
ds = d+d_upper_bar;

// 57 -- changes for risky and mixed branches to:
//chi2_lower_bar * l= 0;

chi2_lower_bar = 0;

chi2_upper_bar = zerop*chi2_upper_bar;

// 58 -- changes for risky and mixed branches to:
//mu_lower_bar * e = 0;

mu_lower_bar = zerop*mu_lower_bar;

mu_upper_bar = zerop*mu_upper_bar;

// 59 
r_e_upper_bar*gamma_var(-1) = ( sigma_bar/q(-1)*tau_var(-1)/sqrt(2*pip)
            *exp(-(  ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_bar+sigma_bar/kap_quality)*q(-1)+xip*sigma_bar)/
                        (sigma_bar*sqrt(2)*tau_var(-1)) 
                   )^2 
                 )
             + 0.5*( r_l*(1-sigma_bar+sigma_bar/kap_quality)-sigma_bar*xip/q(-1)-(1-gamma_var(-1))*r_d(-1)-f_costs )
                  *(1-erf( ( f_costs*q(-1)+r_d(-1)*(1-gamma_var(-1))*q(-1)-r_l*(1-sigma_bar+sigma_bar/kap_quality)*q(-1)+xip*sigma_bar )/
                        (sigma_bar*sqrt(2)*tau_var(-1)) 
                         )  
                    )
           );

// 60
-(1+kappab)*lambda_c+betap*lambda_c(1)*r_e(1)+mu_lower_bar = 0;

// 61 Defines mu_upper_bar
-(1+kappab)*lambda_c+betap*lambda_c(1)*r_e_upper_bar(1)+mu_upper_bar = 0;
 
// 62
//chi2_upper_bar*l_upper_bar = 0;

//l_upper_bar = 0;

// 63
ltot = l+l_upper_bar;

// 64
ltot2ytot = ltot/ytot;

// 65
banking_spread = r_l_lead- r_d*(1-gamma_var(-1)); 

// 4
// Utility, agent 1 
Util1 = ((c-kappap*c(-1))^(1-sigmap_c)-1)/(1-sigmap_c) + sigmap_zero*((ds)^(1-sigmap_d)-1)/(1-sigmap_d);

// Utility, agent 2
Util2 = ((c-kappap*c(-1))^(1-sigmap_c)-1)/(1-sigmap_c) + sigmap_zero*((ds)^(1-sigmap_d)-1)/(1-sigmap_d);

welf = Util1 + betap*welf(1);

utilc = ((c-kappap*c(-1))^(1-sigmap_c)-1)/(1-sigmap_c);

welfc = utilc + betap*welfc(1);

/////////////////////////
// exogenous variables
/////////////////////////

// Other
// 28. TFP process 
log(a) = rhop_a*log(a(-1)) + sigma_eps_a*eps_a;

a_lag = a(-1);

tau_var = taup + rho_taup *(tau_var(-1)-taup) + sigma_eps_tau*eps_tau;

log(kap_quality) = rho_kap_quality*log(kap_quality(-1))+sigma_eps_kap_quality*eps_kap_quality;

log(isp) = rho_isp *log(isp(-1))+sigma_eps_isp*eps_isp;

end;

//steady;

//check;
//
//shocks;
//var eps_gamma = 0.015; 
//end;


//stoch_simul(order=1,nocorr,nomoments,irf=0);

