function [residual, g1, g2] = borrconnotbinding_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 5, 1);

%
% Model equations
%

T20 = y(2)^params(6);
lhs =y(3);
rhs =y(2);
residual(1)= lhs-rhs;
lhs =y(2);
rhs =y(5)+y(1)-y(1)*params(4);
residual(2)= lhs-rhs;
lhs =y(4);
rhs =1/T20-params(4)*params(2)/T20;
residual(3)= lhs-rhs;
residual(4) = y(4);
lhs =log(y(5));
rhs =log(y(5))*params(1)+x(1);
residual(5)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(5, 5);

  %
  % Jacobian matrix
  %

  g1(1,2)=(-1);
  g1(1,3)=1;
  g1(2,1)=(-(1-params(4)));
  g1(2,2)=1;
  g1(2,5)=(-1);
  g1(3,2)=(-((-(getPowerDeriv(y(2),params(6),1)))/(T20*T20)-(-(params(4)*params(2)*getPowerDeriv(y(2),params(6),1)))/(T20*T20)));
  g1(3,4)=1;
  g1(4,4)=1;
  g1(5,5)=1/y(5)-params(1)*1/y(5);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],5,25);
end
end
