function [residual, g1, g2, g3] = cgg_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           columns: equations in order of declaration
%                                                           rows: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(5, 1);
lhs =y(7);
rhs =y(9)-params(7)*(y(4)+y(8))+y(3);
residual(1)= lhs-rhs;
lhs =y(6);
rhs =y(8)*params(2)+y(7)*params(1);
residual(2)= lhs-rhs;
lhs =y(3);
rhs =params(8)*y(1)+x(it_, 1);
residual(3)= lhs-rhs;
lhs =y(5);
rhs =params(6)*y(2)+(1-params(6))*(y(6)*params(3)+y(7)*params(5));
residual(4)= lhs-rhs;
lhs =y(4);
rhs =y(5);
residual(5)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(5, 10);

  %
  % Jacobian matrix
  %

  g1(1,3)=(-1);
  g1(1,4)=params(7);
  g1(1,8)=params(7);
  g1(1,7)=1;
  g1(1,9)=(-1);
  g1(2,6)=1;
  g1(2,8)=(-params(2));
  g1(2,7)=(-params(1));
  g1(3,1)=(-params(8));
  g1(3,3)=1;
  g1(3,10)=(-1);
  g1(4,2)=(-params(6));
  g1(4,5)=1;
  g1(4,6)=(-((1-params(6))*params(3)));
  g1(4,7)=(-((1-params(6))*params(5)));
  g1(5,4)=1;
  g1(5,5)=(-1);
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],5,100);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],5,1000);
end
end
