function [residual, g1, g2, g3] = dnk_zlb_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           columns: equations in order of declaration
%                                                           rows: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(23, 1);
zK_TO_Y__ = params(1)*params(2)/(1-params(1)*(1-params(3)))/params(11);
zC_TO_Y__ = (params(11)-1+params(11)*(1/params(1)-1)*zK_TO_Y__+1-params(2))/params(11)-params(17);
zN_SS__ = ((1-params(2))/zC_TO_Y__/params(11)/params(13)/params(21))^(1/(1+params(4)));
zYY_SS__ = zN_SS__*zK_TO_Y__^(params(2)/(1-params(2)));
T177 = (1-params(14))*(1-params(1)*params(14))/params(14)/(1+params(1));
T209 = (1-params(5))/(1-params(1)*params(5));
T230 = exp(y(26))/(1/params(1)-(1-params(3)));
T320 = (exp(y(18))-params(5)*exp(y(5)))*(exp(y(18))-params(5)*exp(y(5)));
T329 = (exp(y(37))-exp(y(18))*params(5))*(exp(y(37))-exp(y(18))*params(5));
T371 = (-(exp(y(26)+y(36))*exp(y(8))));
T373 = (-(params(1)*exp(y(41))*exp(y(40)+y(44))));
T389 = (-(exp(y(35))*(-((-exp(y(33)))/(exp(y(33))*exp(y(33)))))));
T406 = (exp(y(18))-params(5)*exp(y(5)))*(-(params(5)*exp(y(5))))+(exp(y(18))-params(5)*exp(y(5)))*(-(params(5)*exp(y(5))));
T426 = (exp(y(37))-exp(y(18))*params(5))*(-(exp(y(18))*params(5)))+(exp(y(37))-exp(y(18))*params(5))*(-(exp(y(18))*params(5)));
lhs =exp(y(18))+exp(y(21));
rhs =exp(y(32)+y(23))+(1-params(3)+exp(y(26)+y(36)))*exp(y(8))+(1-1/exp(y(33)))*exp(y(35))-y(28)*zYY_SS__-zYY_SS__*y(17)+zYY_SS__*exp(y(10))*y(4);
residual(1)= lhs-rhs;
lhs =exp(y(29));
rhs =params(1)*exp(y(25)-y(38)+y(41));
residual(2)= lhs-rhs;
lhs =exp(y(29))*exp(y(31));
rhs =params(1)*exp(y(41))*(exp(y(40)+y(44))+(1-params(3))*exp(y(42)));
residual(3)= lhs-rhs;
lhs =exp(y(32)+y(29)-y(34));
rhs =exp(y(30));
residual(4)= lhs-rhs;
lhs =y(35);
rhs =y(16)+(1-params(2))*y(23)+params(2)*(y(36)+y(8));
residual(5)= lhs-rhs;
lhs =y(35)+log(1-params(2))-y(33)-y(23);
rhs =y(32);
residual(6)= lhs-rhs;
lhs =y(35)+log(params(2))-y(33)-y(8);
rhs =y(26)+y(36);
residual(7)= lhs-rhs;
lhs =y(19)-params(12)*y(6);
rhs =params(1)*(y(38)-y(19)*params(12))-(1-params(7))*(1-params(1)*params(7))/params(7)*(y(33)-log(params(11)));
residual(8)= lhs-rhs;
lhs =y(32);
rhs =1/(1+params(1))*y(13)+(1-1/(1+params(1)))*(y(38)+y(43))-y(19)*(1+params(1)*params(15))/(1+params(1))+y(6)*params(15)/(1+params(1))-T177*(y(34)-log(params(13)));
residual(9)= lhs-rhs;
lhs =y(27);
rhs =params(8)*y(11)+y(19)*(1-params(8))*params(10)+(1-params(8))*params(9)/4*(y(35)-log(zYY_SS__))+(1-params(8))*log(1/params(1));
residual(10)= lhs-rhs;
lhs =exp(y(29));
rhs =y(14)+T209*(1/(exp(y(18))-params(5)*exp(y(5)))-params(1)*params(5)/(exp(y(37))-exp(y(18))*params(5)));
residual(11)= lhs-rhs;
lhs =exp(y(30));
rhs =params(21)*exp(y(23))^params(4);
residual(12)= lhs-rhs;
lhs =T230;
rhs =params(16)/(1-params(16))*exp(y(36))+1-params(16)/(1-params(16));
residual(13)= lhs-rhs;
lhs =exp(y(20));
rhs =exp(y(21))-(1-params(3))*exp(y(8));
residual(14)= lhs-rhs;
lhs =exp(y(29))*exp(y(31))*(1-y(22));
rhs =exp(y(29))-params(1)*exp(y(41))*y(39);
residual(15)= lhs-rhs;
lhs =y(22);
rhs =params(6)*(exp(y(20))-exp(y(7)));
residual(16)= lhs-rhs;
lhs =zYY_SS__*y(15);
rhs =zYY_SS__*params(17)*(1-params(18))+zYY_SS__*params(18)*y(2)+zYY_SS__*x(it_, 2);
residual(17)= lhs-rhs;
lhs =zYY_SS__*exp(y(10))*y(4)+zYY_SS__*y(15);
rhs =y(28)*zYY_SS__+zYY_SS__*y(17);
residual(18)= lhs-rhs;
lhs =y(28)*zYY_SS__;
rhs =zYY_SS__*params(24)*y(12)+(1-params(24))*(zYY_SS__*y(4)*params(22)+zYY_SS__*y(15)*params(23));
residual(19)= lhs-rhs;
lhs =y(19);
rhs =y(24)-y(9);
residual(20)= lhs-rhs;
residual(21) = y(25);
lhs =y(14);
rhs =params(20)*y(1)+x(it_, 1);
residual(22)= lhs-rhs;
lhs =y(16);
rhs =params(19)*y(3)+x(it_, 3);
residual(23)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(23, 47);

  %
  % Jacobian matrix
  %

  g1(1,4)=(-(zYY_SS__*exp(y(10))));
  g1(1,17)=zYY_SS__;
  g1(1,18)=exp(y(18));
  g1(1,8)=(-((1-params(3)+exp(y(26)+y(36)))*exp(y(8))));
  g1(1,21)=exp(y(21));
  g1(1,23)=(-exp(y(32)+y(23)));
  g1(1,10)=(-(zYY_SS__*exp(y(10))*y(4)));
  g1(1,26)=T371;
  g1(1,28)=zYY_SS__;
  g1(1,32)=(-exp(y(32)+y(23)));
  g1(1,33)=T389;
  g1(1,35)=(-((1-1/exp(y(33)))*exp(y(35))));
  g1(1,36)=T371;
  g1(2,38)=(-(params(1)*(-exp(y(25)-y(38)+y(41)))));
  g1(2,25)=(-(params(1)*exp(y(25)-y(38)+y(41))));
  g1(2,29)=exp(y(29));
  g1(2,41)=(-(params(1)*exp(y(25)-y(38)+y(41))));
  g1(3,40)=T373;
  g1(3,29)=exp(y(29))*exp(y(31));
  g1(3,41)=(-(params(1)*exp(y(41))*(exp(y(40)+y(44))+(1-params(3))*exp(y(42)))));
  g1(3,31)=exp(y(29))*exp(y(31));
  g1(3,42)=(-(params(1)*exp(y(41))*(1-params(3))*exp(y(42))));
  g1(3,44)=T373;
  g1(4,29)=exp(y(32)+y(29)-y(34));
  g1(4,30)=(-exp(y(30)));
  g1(4,32)=exp(y(32)+y(29)-y(34));
  g1(4,34)=(-exp(y(32)+y(29)-y(34)));
  g1(5,16)=(-1);
  g1(5,8)=(-params(2));
  g1(5,23)=(-(1-params(2)));
  g1(5,35)=1;
  g1(5,36)=(-params(2));
  g1(6,23)=(-1);
  g1(6,32)=(-1);
  g1(6,33)=(-1);
  g1(6,35)=1;
  g1(7,8)=(-1);
  g1(7,26)=(-1);
  g1(7,33)=(-1);
  g1(7,35)=1;
  g1(7,36)=(-1);
  g1(8,6)=(-params(12));
  g1(8,19)=1-params(1)*(-params(12));
  g1(8,38)=(-params(1));
  g1(8,33)=(1-params(7))*(1-params(1)*params(7))/params(7);
  g1(9,6)=(-(params(15)/(1+params(1))));
  g1(9,19)=(1+params(1)*params(15))/(1+params(1));
  g1(9,38)=(-(1-1/(1+params(1))));
  g1(9,13)=(-(1/(1+params(1))));
  g1(9,32)=1;
  g1(9,43)=(-(1-1/(1+params(1))));
  g1(9,34)=T177;
  g1(10,19)=(-((1-params(8))*params(10)));
  g1(10,11)=(-params(8));
  g1(10,27)=1;
  g1(10,35)=(-((1-params(8))*params(9)/4));
  g1(11,14)=(-1);
  g1(11,5)=(-(T209*params(5)*exp(y(5))/T320));
  g1(11,18)=(-(T209*((-exp(y(18)))/T320-(-(params(1)*params(5)*(-(exp(y(18))*params(5)))))/T329)));
  g1(11,37)=(-(T209*(-((-(params(1)*params(5)*exp(y(37))))/T329))));
  g1(11,29)=exp(y(29));
  g1(12,23)=(-(params(21)*exp(y(23))*getPowerDeriv(exp(y(23)),params(4),1)));
  g1(12,30)=exp(y(30));
  g1(13,26)=T230;
  g1(13,36)=(-(params(16)/(1-params(16))*exp(y(36))));
  g1(14,20)=exp(y(20));
  g1(14,8)=(1-params(3))*exp(y(8));
  g1(14,21)=(-exp(y(21)));
  g1(15,22)=(-(exp(y(29))*exp(y(31))));
  g1(15,39)=params(1)*exp(y(41));
  g1(15,29)=exp(y(29))*exp(y(31))*(1-y(22))-exp(y(29));
  g1(15,41)=params(1)*exp(y(41))*y(39);
  g1(15,31)=exp(y(29))*exp(y(31))*(1-y(22));
  g1(16,7)=(-(params(6)*(-exp(y(7)))));
  g1(16,20)=(-(exp(y(20))*params(6)));
  g1(16,22)=1;
  g1(17,2)=(-(zYY_SS__*params(18)));
  g1(17,15)=zYY_SS__;
  g1(17,46)=(-zYY_SS__);
  g1(18,15)=zYY_SS__;
  g1(18,4)=zYY_SS__*exp(y(10));
  g1(18,17)=(-zYY_SS__);
  g1(18,10)=zYY_SS__*exp(y(10))*y(4);
  g1(18,28)=(-zYY_SS__);
  g1(19,15)=(-((1-params(24))*zYY_SS__*params(23)));
  g1(19,4)=(-((1-params(24))*zYY_SS__*params(22)));
  g1(19,12)=(-(zYY_SS__*params(24)));
  g1(19,28)=zYY_SS__;
  g1(20,19)=1;
  g1(20,9)=1;
  g1(20,24)=(-1);
  g1(21,25)=1;
  g1(22,1)=(-params(20));
  g1(22,14)=1;
  g1(22,45)=(-1);
  g1(23,3)=(-params(19));
  g1(23,16)=1;
  g1(23,47)=(-1);
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(89,3);
  v2(1,1)=1;
  v2(1,2)=817;
  v2(1,3)=exp(y(18));
  v2(2,1)=1;
  v2(2,2)=337;
  v2(2,3)=(-((1-params(3)+exp(y(26)+y(36)))*exp(y(8))));
  v2(3,1)=1;
  v2(3,2)=961;
  v2(3,3)=exp(y(21));
  v2(4,1)=1;
  v2(4,2)=1057;
  v2(4,3)=(-exp(y(32)+y(23)));
  v2(5,1)=1;
  v2(5,2)=427;
  v2(5,3)=(-(zYY_SS__*exp(y(10))));
  v2(6,1)=1;
  v2(6,2)=151;
  v2(6,3)=  v2(5,3);
  v2(7,1)=1;
  v2(7,2)=433;
  v2(7,3)=(-(zYY_SS__*exp(y(10))*y(4)));
  v2(8,1)=1;
  v2(8,2)=1183;
  v2(8,3)=T371;
  v2(9,1)=1;
  v2(9,2)=355;
  v2(9,3)=  v2(8,3);
  v2(10,1)=1;
  v2(10,2)=1201;
  v2(10,3)=T371;
  v2(11,1)=1;
  v2(11,2)=1480;
  v2(11,3)=(-exp(y(32)+y(23)));
  v2(12,1)=1;
  v2(12,2)=1066;
  v2(12,3)=  v2(11,3);
  v2(13,1)=1;
  v2(13,2)=1489;
  v2(13,3)=(-exp(y(32)+y(23)));
  v2(14,1)=1;
  v2(14,2)=1537;
  v2(14,3)=(-(exp(y(35))*(-(((-exp(y(33)))*exp(y(33))*exp(y(33))-(-exp(y(33)))*(exp(y(33))*exp(y(33))+exp(y(33))*exp(y(33))))/(exp(y(33))*exp(y(33))*exp(y(33))*exp(y(33)))))));
  v2(15,1)=1;
  v2(15,2)=1631;
  v2(15,3)=T389;
  v2(16,1)=1;
  v2(16,2)=1539;
  v2(16,3)=  v2(15,3);
  v2(17,1)=1;
  v2(17,2)=1633;
  v2(17,3)=(-((1-1/exp(y(33)))*exp(y(35))));
  v2(18,1)=1;
  v2(18,2)=1653;
  v2(18,3)=T371;
  v2(19,1)=1;
  v2(19,2)=365;
  v2(19,3)=  v2(18,3);
  v2(20,1)=1;
  v2(20,2)=1671;
  v2(20,3)=T371;
  v2(21,1)=1;
  v2(21,2)=1211;
  v2(21,3)=  v2(20,3);
  v2(22,1)=1;
  v2(22,2)=1681;
  v2(22,3)=T371;
  v2(23,1)=2;
  v2(23,2)=1777;
  v2(23,3)=(-(params(1)*exp(y(25)-y(38)+y(41))));
  v2(24,1)=2;
  v2(24,2)=1166;
  v2(24,3)=(-(params(1)*(-exp(y(25)-y(38)+y(41)))));
  v2(25,1)=2;
  v2(25,2)=1764;
  v2(25,3)=  v2(24,3);
  v2(26,1)=2;
  v2(26,2)=1153;
  v2(26,3)=(-(params(1)*exp(y(25)-y(38)+y(41))));
  v2(27,1)=2;
  v2(27,2)=1345;
  v2(27,3)=exp(y(29));
  v2(28,1)=2;
  v2(28,2)=1918;
  v2(28,3)=(-(params(1)*(-exp(y(25)-y(38)+y(41)))));
  v2(29,1)=2;
  v2(29,2)=1780;
  v2(29,3)=  v2(28,3);
  v2(30,1)=2;
  v2(30,2)=1905;
  v2(30,3)=(-(params(1)*exp(y(25)-y(38)+y(41))));
  v2(31,1)=2;
  v2(31,2)=1169;
  v2(31,3)=  v2(30,3);
  v2(32,1)=2;
  v2(32,2)=1921;
  v2(32,3)=(-(params(1)*exp(y(25)-y(38)+y(41))));
  v2(33,1)=3;
  v2(33,2)=1873;
  v2(33,3)=T373;
  v2(34,1)=3;
  v2(34,2)=1345;
  v2(34,3)=exp(y(29))*exp(y(31));
  v2(35,1)=3;
  v2(35,2)=1920;
  v2(35,3)=T373;
  v2(36,1)=3;
  v2(36,2)=1874;
  v2(36,3)=  v2(35,3);
  v2(37,1)=3;
  v2(37,2)=1921;
  v2(37,3)=(-(params(1)*exp(y(41))*(exp(y(40)+y(44))+(1-params(3))*exp(y(42)))));
  v2(38,1)=3;
  v2(38,2)=1439;
  v2(38,3)=exp(y(29))*exp(y(31));
  v2(39,1)=3;
  v2(39,2)=1347;
  v2(39,3)=  v2(38,3);
  v2(40,1)=3;
  v2(40,2)=1441;
  v2(40,3)=exp(y(29))*exp(y(31));
  v2(41,1)=3;
  v2(41,2)=1968;
  v2(41,3)=(-(params(1)*exp(y(41))*(1-params(3))*exp(y(42))));
  v2(42,1)=3;
  v2(42,2)=1922;
  v2(42,3)=  v2(41,3);
  v2(43,1)=3;
  v2(43,2)=1969;
  v2(43,3)=(-(params(1)*exp(y(41))*(1-params(3))*exp(y(42))));
  v2(44,1)=3;
  v2(44,2)=2061;
  v2(44,3)=T373;
  v2(45,1)=3;
  v2(45,2)=1877;
  v2(45,3)=  v2(44,3);
  v2(46,1)=3;
  v2(46,2)=2062;
  v2(46,3)=T373;
  v2(47,1)=3;
  v2(47,2)=1924;
  v2(47,3)=  v2(46,3);
  v2(48,1)=3;
  v2(48,2)=2065;
  v2(48,3)=T373;
  v2(49,1)=4;
  v2(49,2)=1345;
  v2(49,3)=exp(y(32)+y(29)-y(34));
  v2(50,1)=4;
  v2(50,2)=1393;
  v2(50,3)=(-exp(y(30)));
  v2(51,1)=4;
  v2(51,2)=1486;
  v2(51,3)=exp(y(32)+y(29)-y(34));
  v2(52,1)=4;
  v2(52,2)=1348;
  v2(52,3)=  v2(51,3);
  v2(53,1)=4;
  v2(53,2)=1489;
  v2(53,3)=exp(y(32)+y(29)-y(34));
  v2(54,1)=4;
  v2(54,2)=1580;
  v2(54,3)=(-exp(y(32)+y(29)-y(34)));
  v2(55,1)=4;
  v2(55,2)=1350;
  v2(55,3)=  v2(54,3);
  v2(56,1)=4;
  v2(56,2)=1583;
  v2(56,3)=(-exp(y(32)+y(29)-y(34)));
  v2(57,1)=4;
  v2(57,2)=1491;
  v2(57,3)=  v2(56,3);
  v2(58,1)=4;
  v2(58,2)=1585;
  v2(58,3)=exp(y(32)+y(29)-y(34));
  v2(59,1)=11;
  v2(59,2)=193;
  v2(59,3)=(-(T209*(params(5)*exp(y(5))*T320-params(5)*exp(y(5))*T406)/(T320*T320)));
  v2(60,1)=11;
  v2(60,2)=804;
  v2(60,3)=(-(T209*(-((-exp(y(18)))*T406))/(T320*T320)));
  v2(61,1)=11;
  v2(61,2)=206;
  v2(61,3)=  v2(60,3);
  v2(62,1)=11;
  v2(62,2)=817;
  v2(62,3)=(-(T209*((T320*(-exp(y(18)))-(-exp(y(18)))*(exp(y(18))*(exp(y(18))-params(5)*exp(y(5)))+exp(y(18))*(exp(y(18))-params(5)*exp(y(5)))))/(T320*T320)-((-(params(1)*params(5)*(-(exp(y(18))*params(5)))))*T329-(-(params(1)*params(5)*(-(exp(y(18))*params(5)))))*T426)/(T329*T329))));
  v2(63,1)=11;
  v2(63,2)=1710;
  v2(63,3)=(-(T209*(-((-((-(params(1)*params(5)*exp(y(37))))*T426))/(T329*T329)))));
  v2(64,1)=11;
  v2(64,2)=836;
  v2(64,3)=  v2(63,3);
  v2(65,1)=11;
  v2(65,2)=1729;
  v2(65,3)=(-(T209*(-((T329*(-(params(1)*params(5)*exp(y(37))))-(-(params(1)*params(5)*exp(y(37))))*(exp(y(37))*(exp(y(37))-exp(y(18))*params(5))+exp(y(37))*(exp(y(37))-exp(y(18))*params(5))))/(T329*T329)))));
  v2(66,1)=11;
  v2(66,2)=1345;
  v2(66,3)=exp(y(29));
  v2(67,1)=12;
  v2(67,2)=1057;
  v2(67,3)=(-(params(21)*(exp(y(23))*getPowerDeriv(exp(y(23)),params(4),1)+exp(y(23))*exp(y(23))*getPowerDeriv(exp(y(23)),params(4),2))));
  v2(68,1)=12;
  v2(68,2)=1393;
  v2(68,3)=exp(y(30));
  v2(69,1)=13;
  v2(69,2)=1201;
  v2(69,3)=T230;
  v2(70,1)=13;
  v2(70,2)=1681;
  v2(70,3)=(-(params(16)/(1-params(16))*exp(y(36))));
  v2(71,1)=14;
  v2(71,2)=913;
  v2(71,3)=exp(y(20));
  v2(72,1)=14;
  v2(72,2)=337;
  v2(72,3)=(1-params(3))*exp(y(8));
  v2(73,1)=14;
  v2(73,2)=961;
  v2(73,3)=(-exp(y(21)));
  v2(74,1)=15;
  v2(74,2)=1338;
  v2(74,3)=(-(exp(y(29))*exp(y(31))));
  v2(75,1)=15;
  v2(75,2)=1016;
  v2(75,3)=  v2(74,3);
  v2(76,1)=15;
  v2(76,2)=1345;
  v2(76,3)=exp(y(29))*exp(y(31))*(1-y(22))-exp(y(29));
  v2(77,1)=15;
  v2(77,2)=1919;
  v2(77,3)=params(1)*exp(y(41));
  v2(78,1)=15;
  v2(78,2)=1827;
  v2(78,3)=  v2(77,3);
  v2(79,1)=15;
  v2(79,2)=1921;
  v2(79,3)=params(1)*exp(y(41))*y(39);
  v2(80,1)=15;
  v2(80,2)=1432;
  v2(80,3)=(-(exp(y(29))*exp(y(31))));
  v2(81,1)=15;
  v2(81,2)=1018;
  v2(81,3)=  v2(80,3);
  v2(82,1)=15;
  v2(82,2)=1439;
  v2(82,3)=exp(y(29))*exp(y(31))*(1-y(22));
  v2(83,1)=15;
  v2(83,2)=1347;
  v2(83,3)=  v2(82,3);
  v2(84,1)=15;
  v2(84,2)=1441;
  v2(84,3)=exp(y(29))*exp(y(31))*(1-y(22));
  v2(85,1)=16;
  v2(85,2)=289;
  v2(85,3)=(-(params(6)*(-exp(y(7)))));
  v2(86,1)=16;
  v2(86,2)=913;
  v2(86,3)=(-(exp(y(20))*params(6)));
  v2(87,1)=18;
  v2(87,2)=427;
  v2(87,3)=zYY_SS__*exp(y(10));
  v2(88,1)=18;
  v2(88,2)=151;
  v2(88,3)=  v2(87,3);
  v2(89,1)=18;
  v2(89,2)=433;
  v2(89,3)=zYY_SS__*exp(y(10))*y(4);
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),23,2209);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],23,103823);
end
end
