function [residual, g1, g2, g3] = dynrbc_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 6, 1);

%
% Model equations
%

T36 = exp(y(2))^(-params(4));
T51 = params(1)*exp(y(1))*exp(y(4))^(params(1)-1);
T67 = exp(y(1))*exp(y(4))^params(1);
lhs =(-T36)+params(3)*T36*(1-params(2)+T51);
rhs =(-y(6))+y(6)*params(3)*(1-params(2)+params(7));
residual(1)= lhs-rhs;
lhs =exp(y(2))+exp(y(4))-exp(y(4))*(1-params(2));
rhs =T67;
residual(2)= lhs-rhs;
lhs =exp(y(3));
rhs =exp(y(4))-exp(y(4))*(1-params(2));
residual(3)= lhs-rhs;
residual(4) = y(6);
lhs =y(1);
rhs =y(1)*params(5)+x(1);
residual(5)= lhs-rhs;
lhs =y(5);
rhs =y(4);
residual(6)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(6, 6);

  %
  % Jacobian matrix
  %

T85 = exp(y(2))*getPowerDeriv(exp(y(2)),(-params(4)),1);
  g1(1,1)=params(3)*T36*T51;
  g1(1,2)=(-T85)+(1-params(2)+T51)*params(3)*T85;
  g1(1,4)=params(3)*T36*params(1)*exp(y(1))*exp(y(4))*getPowerDeriv(exp(y(4)),params(1)-1,1);
  g1(1,6)=(-((-1)+params(3)*(1-params(2)+params(7))));
  g1(2,1)=(-T67);
  g1(2,2)=exp(y(2));
  g1(2,4)=exp(y(4))-exp(y(4))*(1-params(2))-exp(y(1))*exp(y(4))*getPowerDeriv(exp(y(4)),params(1),1);
  g1(3,3)=exp(y(3));
  g1(3,4)=(-(exp(y(4))-exp(y(4))*(1-params(2))));
  g1(4,6)=1;
  g1(5,1)=1-params(5);
  g1(6,4)=(-1);
  g1(6,5)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],6,36);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],6,216);
end
end
end
end
