function [residual, g1, g2, g3] = dynrbcirr_i_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(6, 1);
zkss__ = ((1/params(3)-1+params(2))/params(1))^(1/(params(1)-1));
ziss__ = params(2)*zkss__;
T34 = (-(exp(y(4))^(-params(4))));
T41 = exp(y(6))/exp(y(2));
T42 = T41-1;
T45 = 1+2*params(8)*T42/exp(y(2));
T50 = params(3)*exp(y(10))^(-params(4));
T56 = 2*params(8)*(exp(y(11))/exp(y(6))-1);
T58 = exp(y(6))^2;
T59 = (-exp(y(11)))/T58;
T66 = params(1)*exp(y(9))*exp(y(6))^(params(1)-1);
T67 = 1-params(2)-T56*T59+T66;
T88 = exp(y(3))*exp(y(2))^params(1);
lhs =T34*T45+T50*T67;
rhs =(-y(8))+params(3)*(1-params(2)+params(7))*y(12);
residual(1)= lhs-rhs;
lhs =exp(y(4))+exp(y(6))-exp(y(2))*(1-params(2))+params(8)*T42^2;
rhs =T88;
residual(2)= lhs-rhs;
lhs =exp(y(5));
rhs =exp(y(6))-exp(y(2))*(1-params(2));
residual(3)= lhs-rhs;
lhs =y(5);
rhs =log(params(6)*ziss__);
residual(4)= lhs-rhs;
lhs =y(3);
rhs =params(5)*y(1)+x(it_, 1);
residual(5)= lhs-rhs;
lhs =y(7);
rhs =y(2);
residual(6)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(6, 13);

  %
  % Jacobian matrix
  %

T111 = exp(y(4))*getPowerDeriv(exp(y(4)),(-params(4)),1);
T115 = exp(y(10))*getPowerDeriv(exp(y(10)),(-params(4)),1);
T116 = params(3)*T115;
T120 = exp(y(2))*exp(y(2));
T121 = (-(exp(y(6))*exp(y(2))))/T120;
T126 = (exp(y(2))*2*params(8)*T121-exp(y(2))*2*params(8)*T42)/T120;
T134 = exp(y(2))*getPowerDeriv(exp(y(2)),params(1),1);
T135 = exp(y(3))*T134;
T144 = 2*params(8)*(-(exp(y(6))*exp(y(11))))/(exp(y(6))*exp(y(6)));
T150 = (-((-exp(y(11)))*exp(y(6))*2*exp(y(6))))/(T58*T58);
T156 = exp(y(6))*getPowerDeriv(exp(y(6)),params(1)-1,1);
T157 = params(1)*exp(y(9))*T156;
T158 = (-(T59*T144+T56*T150))+T157;
T166 = T59*2*params(8)*exp(y(11))/exp(y(6));
T168 = (-(T56*T59+T166));
  g1(1,9)=T50*T66;
  g1(1,4)=T45*(-T111);
  g1(1,10)=T67*T116;
  g1(1,2)=T34*T126;
  g1(1,6)=T34*2*params(8)*T41/exp(y(2))+T50*T158;
  g1(1,11)=T50*T168;
  g1(1,8)=1;
  g1(1,12)=(-(params(3)*(1-params(2)+params(7))));
  g1(2,3)=(-T88);
  g1(2,4)=exp(y(4));
  g1(2,2)=(-(exp(y(2))*(1-params(2))))+params(8)*T121*2*T42-T135;
  g1(2,6)=exp(y(6))+params(8)*T41*2*T42;
  g1(3,5)=exp(y(5));
  g1(3,2)=exp(y(2))*(1-params(2));
  g1(3,6)=(-exp(y(6)));
  g1(4,5)=1;
  g1(5,1)=(-params(5));
  g1(5,3)=1;
  g1(5,13)=(-1);
  g1(6,2)=(-1);
  g1(6,7)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(33,3);
T190 = ((-(exp(y(6))*exp(y(2))))*T120-(-(exp(y(6))*exp(y(2))))*(T120+T120))/(T120*T120);
  v2(1,1)=1;
  v2(1,2)=113;
  v2(1,3)=T50*T66;
  v2(2,1)=1;
  v2(2,2)=43;
  v2(2,3)=T45*(-(T111+exp(y(4))*exp(y(4))*getPowerDeriv(exp(y(4)),(-params(4)),2)));
  v2(3,1)=1;
  v2(3,2)=126;
  v2(3,3)=T66*T116;
  v2(4,1)=1;
  v2(4,2)=114;
  v2(4,3)=  v2(3,3);
  v2(5,1)=1;
  v2(5,2)=127;
  v2(5,3)=T67*params(3)*(T115+exp(y(10))*exp(y(10))*getPowerDeriv(exp(y(10)),(-params(4)),2));
  v2(6,1)=1;
  v2(6,2)=17;
  v2(6,3)=(-T111)*T126;
  v2(7,1)=1;
  v2(7,2)=41;
  v2(7,3)=  v2(6,3);
  v2(8,1)=1;
  v2(8,2)=15;
  v2(8,3)=T34*(T120*(exp(y(2))*2*params(8)*T121+exp(y(2))*2*params(8)*T190-(exp(y(2))*2*params(8)*T121+exp(y(2))*2*params(8)*T42))-(exp(y(2))*2*params(8)*T121-exp(y(2))*2*params(8)*T42)*(T120+T120))/(T120*T120);
  v2(9,1)=1;
  v2(9,2)=74;
  v2(9,3)=T50*T157;
  v2(10,1)=1;
  v2(10,2)=110;
  v2(10,3)=  v2(9,3);
  v2(11,1)=1;
  v2(11,2)=69;
  v2(11,3)=(-T111)*2*params(8)*T41/exp(y(2));
  v2(12,1)=1;
  v2(12,2)=45;
  v2(12,3)=  v2(11,3);
  v2(13,1)=1;
  v2(13,2)=75;
  v2(13,3)=T116*T158;
  v2(14,1)=1;
  v2(14,2)=123;
  v2(14,3)=  v2(13,3);
  v2(15,1)=1;
  v2(15,2)=67;
  v2(15,3)=T34*(exp(y(2))*2*params(8)*T121-exp(y(2))*2*params(8)*T41)/T120;
  v2(16,1)=1;
  v2(16,2)=19;
  v2(16,3)=  v2(15,3);
  v2(17,1)=1;
  v2(17,2)=71;
  v2(17,3)=T34*2*params(8)*T41/exp(y(2))+T50*((-(T144*T150+T59*2*params(8)*((-(exp(y(6))*exp(y(11))))*exp(y(6))*exp(y(6))-(-(exp(y(6))*exp(y(11))))*(exp(y(6))*exp(y(6))+exp(y(6))*exp(y(6))))/(exp(y(6))*exp(y(6))*exp(y(6))*exp(y(6)))+T144*T150+T56*(T58*T58*(-((-exp(y(11)))*(exp(y(6))*2*exp(y(6))+exp(y(6))*2*exp(y(6)))))-(-((-exp(y(11)))*exp(y(6))*2*exp(y(6))))*(T58*exp(y(6))*2*exp(y(6))+T58*exp(y(6))*2*exp(y(6))))/(T58*T58*T58*T58)))+params(1)*exp(y(9))*(T156+exp(y(6))*exp(y(6))*getPowerDeriv(exp(y(6)),params(1)-1,2)));
  v2(18,1)=1;
  v2(18,2)=140;
  v2(18,3)=T116*T168;
  v2(19,1)=1;
  v2(19,2)=128;
  v2(19,3)=  v2(18,3);
  v2(20,1)=1;
  v2(20,2)=136;
  v2(20,3)=T50*(-(T59*T144+T56*T150+T59*T144+T150*2*params(8)*exp(y(11))/exp(y(6))));
  v2(21,1)=1;
  v2(21,2)=76;
  v2(21,3)=  v2(20,3);
  v2(22,1)=1;
  v2(22,2)=141;
  v2(22,3)=T50*(-(T56*T59+T166+T166+T166));
  v2(23,1)=2;
  v2(23,2)=29;
  v2(23,3)=(-T88);
  v2(24,1)=2;
  v2(24,2)=43;
  v2(24,3)=exp(y(4));
  v2(25,1)=2;
  v2(25,2)=16;
  v2(25,3)=(-T135);
  v2(26,1)=2;
  v2(26,2)=28;
  v2(26,3)=  v2(25,3);
  v2(27,1)=2;
  v2(27,2)=15;
  v2(27,3)=(-(exp(y(2))*(1-params(2))))+params(8)*(2*T42*T190+T121*2*T121)-exp(y(3))*(T134+exp(y(2))*exp(y(2))*getPowerDeriv(exp(y(2)),params(1),2));
  v2(28,1)=2;
  v2(28,2)=67;
  v2(28,3)=params(8)*(T121*2*T42+T41*2*T121);
  v2(29,1)=2;
  v2(29,2)=19;
  v2(29,3)=  v2(28,3);
  v2(30,1)=2;
  v2(30,2)=71;
  v2(30,3)=exp(y(6))+params(8)*(T41*2*T42+T41*2*T41);
  v2(31,1)=3;
  v2(31,2)=57;
  v2(31,3)=exp(y(5));
  v2(32,1)=3;
  v2(32,2)=15;
  v2(32,3)=exp(y(2))*(1-params(2));
  v2(33,1)=3;
  v2(33,2)=71;
  v2(33,3)=(-exp(y(6)));
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),6,169);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],6,2197);
end
end
end
end
