function [residual, g1, g2, g3] = dynrbc_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           columns: equations in order of declaration
%                                                           rows: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(5, 1);
T37 = (-(exp(y(4))^(-params(4))));
T44 = exp(y(6))/exp(y(2));
T45 = T44-1;
T48 = 1+2*params(7)*T45/exp(y(2));
T53 = params(3)*exp(y(9))^(-params(4));
T61 = exp(y(6))^2;
T62 = (-exp(y(10)))/T61;
T70 = 1-params(2)-2*params(7)*(exp(y(10))/exp(y(6))-1)*T62+params(1)*exp(y(8))*exp(y(6))^(params(1)-1);
T116 = (-(exp(y(6))*exp(y(2))))/(exp(y(2))*exp(y(2)));
lhs =T37*T48+T53*T70;
rhs =(-y(7))+params(3)*(1-params(2))*y(11);
residual(1)= lhs-rhs;
lhs =exp(y(4))+exp(y(6))-exp(y(2))*(1-params(2))+params(7)*T45^2;
rhs =exp(y(3))*exp(y(2))^params(1);
residual(2)= lhs-rhs;
lhs =exp(y(5));
rhs =exp(y(6))-exp(y(2))*(1-params(2));
residual(3)= lhs-rhs;
residual(4) = y(7);
lhs =y(3);
rhs =params(5)*y(1)+x(it_, 1);
residual(5)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(5, 12);

  %
  % Jacobian matrix
  %

  g1(1,8)=T53*params(1)*exp(y(8))*exp(y(6))^(params(1)-1);
  g1(1,4)=T48*(-(exp(y(4))*getPowerDeriv(exp(y(4)),(-params(4)),1)));
  g1(1,9)=T70*params(3)*exp(y(9))*getPowerDeriv(exp(y(9)),(-params(4)),1);
  g1(1,2)=T37*(exp(y(2))*2*params(7)*T116-exp(y(2))*2*params(7)*T45)/(exp(y(2))*exp(y(2)));
  g1(1,6)=T37*2*params(7)*T44/exp(y(2))+T53*((-(T62*2*params(7)*(-(exp(y(6))*exp(y(10))))/(exp(y(6))*exp(y(6)))+2*params(7)*(exp(y(10))/exp(y(6))-1)*(-((-exp(y(10)))*exp(y(6))*2*exp(y(6))))/(T61*T61)))+params(1)*exp(y(8))*exp(y(6))*getPowerDeriv(exp(y(6)),params(1)-1,1));
  g1(1,10)=T53*(-(2*params(7)*(exp(y(10))/exp(y(6))-1)*T62+T62*2*params(7)*exp(y(10))/exp(y(6))));
  g1(1,7)=1;
  g1(1,11)=(-(params(3)*(1-params(2))));
  g1(2,3)=(-(exp(y(3))*exp(y(2))^params(1)));
  g1(2,4)=exp(y(4));
  g1(2,2)=(-(exp(y(2))*(1-params(2))))+params(7)*T116*2*T45-exp(y(3))*exp(y(2))*getPowerDeriv(exp(y(2)),params(1),1);
  g1(2,6)=exp(y(6))+params(7)*T44*2*T45;
  g1(3,5)=exp(y(5));
  g1(3,2)=exp(y(2))*(1-params(2));
  g1(3,6)=(-exp(y(6)));
  g1(4,7)=1;
  g1(5,1)=(-params(5));
  g1(5,3)=1;
  g1(5,12)=(-1);
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],5,144);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],5,1728);
end
end
