function [residual, g1, g2, g3] = dynrbcirrineg_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           columns: equations in order of declaration
%                                                           rows: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(5, 1);
zkss__ = ((1/params(3)-1+params(2))/params(1))^(1/(params(1)-1));
ziss__ = params(2)*zkss__;
T34 = (-(exp(y(4))^(-params(4))));
T41 = exp(y(6))/exp(y(2));
T42 = T41-1;
T45 = 1+2*params(8)*T42/exp(y(2));
T50 = params(3)*exp(y(9))^(-params(4));
T56 = 2*params(8)*(exp(y(10))/exp(y(6))-1);
T58 = exp(y(6))^2;
T59 = (-exp(y(10)))/T58;
T66 = params(1)*exp(y(8))*exp(y(6))^(params(1)-1);
T67 = 1-params(2)-T56*T59+T66;
T105 = T50*T66;
T108 = (-(exp(y(4))*getPowerDeriv(exp(y(4)),(-params(4)),1)));
T112 = params(3)*exp(y(9))*getPowerDeriv(exp(y(9)),(-params(4)),1);
T116 = exp(y(2))*exp(y(2));
T117 = (-(exp(y(6))*exp(y(2))))/T116;
T122 = (exp(y(2))*2*params(8)*T117-exp(y(2))*2*params(8)*T42)/T116;
T131 = exp(y(3))*exp(y(2))*getPowerDeriv(exp(y(2)),params(1),1);
T140 = 2*params(8)*(-(exp(y(6))*exp(y(10))))/(exp(y(6))*exp(y(6)));
T146 = (-((-exp(y(10)))*exp(y(6))*2*exp(y(6))))/(T58*T58);
T153 = params(1)*exp(y(8))*exp(y(6))*getPowerDeriv(exp(y(6)),params(1)-1,1);
T154 = (-(T59*T140+T56*T146))+T153;
T162 = T59*2*params(8)*exp(y(10))/exp(y(6));
T164 = (-(T56*T59+T162));
T186 = ((-(exp(y(6))*exp(y(2))))*T116-(-(exp(y(6))*exp(y(2))))*(T116+T116))/(T116*T116);
lhs =T34*T45+T50*T67;
rhs =(-y(7))+params(3)*(1-params(2))*y(11);
residual(1)= lhs-rhs;
lhs =exp(y(4))+exp(y(6))-exp(y(2))*(1-params(2))+params(8)*T42^2;
rhs =exp(y(3))*exp(y(2))^params(1);
residual(2)= lhs-rhs;
lhs =exp(y(5));
rhs =exp(y(6))-exp(y(2))*(1-params(2));
residual(3)= lhs-rhs;
lhs =y(5);
rhs =log(params(6)*ziss__);
residual(4)= lhs-rhs;
lhs =y(3);
rhs =params(5)*y(1)+x(it_, 1);
residual(5)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(5, 12);

  %
  % Jacobian matrix
  %

  g1(1,8)=T105;
  g1(1,4)=T45*T108;
  g1(1,9)=T67*T112;
  g1(1,2)=T34*T122;
  g1(1,6)=T34*2*params(8)*T41/exp(y(2))+T50*T154;
  g1(1,10)=T50*T164;
  g1(1,7)=1;
  g1(1,11)=(-(params(3)*(1-params(2))));
  g1(2,3)=(-(exp(y(3))*exp(y(2))^params(1)));
  g1(2,4)=exp(y(4));
  g1(2,2)=(-(exp(y(2))*(1-params(2))))+params(8)*T117*2*T42-T131;
  g1(2,6)=exp(y(6))+params(8)*T41*2*T42;
  g1(3,5)=exp(y(5));
  g1(3,2)=exp(y(2))*(1-params(2));
  g1(3,6)=(-exp(y(6)));
  g1(4,5)=1;
  g1(5,1)=(-params(5));
  g1(5,3)=1;
  g1(5,12)=(-1);
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(33,3);
  v2(1,1)=1;
  v2(1,2)=92;
  v2(1,3)=T105;
  v2(2,1)=1;
  v2(2,2)=40;
  v2(2,3)=T45*(-(exp(y(4))*getPowerDeriv(exp(y(4)),(-params(4)),1)+exp(y(4))*exp(y(4))*getPowerDeriv(exp(y(4)),(-params(4)),2)));
  v2(3,1)=1;
  v2(3,2)=104;
  v2(3,3)=T66*T112;
  v2(4,1)=1;
  v2(4,2)=93;
  v2(4,3)=  v2(3,3);
  v2(5,1)=1;
  v2(5,2)=105;
  v2(5,3)=T67*params(3)*(exp(y(9))*getPowerDeriv(exp(y(9)),(-params(4)),1)+exp(y(9))*exp(y(9))*getPowerDeriv(exp(y(9)),(-params(4)),2));
  v2(6,1)=1;
  v2(6,2)=16;
  v2(6,3)=T108*T122;
  v2(7,1)=1;
  v2(7,2)=38;
  v2(7,3)=  v2(6,3);
  v2(8,1)=1;
  v2(8,2)=14;
  v2(8,3)=T34*(T116*(exp(y(2))*2*params(8)*T117+exp(y(2))*2*params(8)*T186-(exp(y(2))*2*params(8)*T117+exp(y(2))*2*params(8)*T42))-(exp(y(2))*2*params(8)*T117-exp(y(2))*2*params(8)*T42)*(T116+T116))/(T116*T116);
  v2(9,1)=1;
  v2(9,2)=68;
  v2(9,3)=T50*T153;
  v2(10,1)=1;
  v2(10,2)=90;
  v2(10,3)=  v2(9,3);
  v2(11,1)=1;
  v2(11,2)=64;
  v2(11,3)=T108*2*params(8)*T41/exp(y(2));
  v2(12,1)=1;
  v2(12,2)=42;
  v2(12,3)=  v2(11,3);
  v2(13,1)=1;
  v2(13,2)=69;
  v2(13,3)=T112*T154;
  v2(14,1)=1;
  v2(14,2)=102;
  v2(14,3)=  v2(13,3);
  v2(15,1)=1;
  v2(15,2)=62;
  v2(15,3)=T34*(exp(y(2))*2*params(8)*T117-exp(y(2))*2*params(8)*T41)/T116;
  v2(16,1)=1;
  v2(16,2)=18;
  v2(16,3)=  v2(15,3);
  v2(17,1)=1;
  v2(17,2)=66;
  v2(17,3)=T34*2*params(8)*T41/exp(y(2))+T50*((-(T140*T146+T59*2*params(8)*((-(exp(y(6))*exp(y(10))))*exp(y(6))*exp(y(6))-(-(exp(y(6))*exp(y(10))))*(exp(y(6))*exp(y(6))+exp(y(6))*exp(y(6))))/(exp(y(6))*exp(y(6))*exp(y(6))*exp(y(6)))+T140*T146+T56*(T58*T58*(-((-exp(y(10)))*(exp(y(6))*2*exp(y(6))+exp(y(6))*2*exp(y(6)))))-(-((-exp(y(10)))*exp(y(6))*2*exp(y(6))))*(T58*exp(y(6))*2*exp(y(6))+T58*exp(y(6))*2*exp(y(6))))/(T58*T58*T58*T58)))+params(1)*exp(y(8))*(exp(y(6))*getPowerDeriv(exp(y(6)),params(1)-1,1)+exp(y(6))*exp(y(6))*getPowerDeriv(exp(y(6)),params(1)-1,2)));
  v2(18,1)=1;
  v2(18,2)=117;
  v2(18,3)=T112*T164;
  v2(19,1)=1;
  v2(19,2)=106;
  v2(19,3)=  v2(18,3);
  v2(20,1)=1;
  v2(20,2)=114;
  v2(20,3)=T50*(-(T59*T140+T56*T146+T59*T140+T146*2*params(8)*exp(y(10))/exp(y(6))));
  v2(21,1)=1;
  v2(21,2)=70;
  v2(21,3)=  v2(20,3);
  v2(22,1)=1;
  v2(22,2)=118;
  v2(22,3)=T50*(-(T56*T59+T162+T162+T162));
  v2(23,1)=2;
  v2(23,2)=27;
  v2(23,3)=(-(exp(y(3))*exp(y(2))^params(1)));
  v2(24,1)=2;
  v2(24,2)=40;
  v2(24,3)=exp(y(4));
  v2(25,1)=2;
  v2(25,2)=15;
  v2(25,3)=(-T131);
  v2(26,1)=2;
  v2(26,2)=26;
  v2(26,3)=  v2(25,3);
  v2(27,1)=2;
  v2(27,2)=14;
  v2(27,3)=(-(exp(y(2))*(1-params(2))))+params(8)*(2*T42*T186+T117*2*T117)-exp(y(3))*(exp(y(2))*getPowerDeriv(exp(y(2)),params(1),1)+exp(y(2))*exp(y(2))*getPowerDeriv(exp(y(2)),params(1),2));
  v2(28,1)=2;
  v2(28,2)=62;
  v2(28,3)=params(8)*(T117*2*T42+T41*2*T117);
  v2(29,1)=2;
  v2(29,2)=18;
  v2(29,3)=  v2(28,3);
  v2(30,1)=2;
  v2(30,2)=66;
  v2(30,3)=exp(y(6))+params(8)*(T41*2*T42+T41*2*T41);
  v2(31,1)=3;
  v2(31,2)=53;
  v2(31,3)=exp(y(5));
  v2(32,1)=3;
  v2(32,2)=14;
  v2(32,3)=exp(y(2))*(1-params(2));
  v2(33,1)=3;
  v2(33,2)=66;
  v2(33,3)=(-exp(y(6)));
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),5,144);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],5,1728);
end
end
