function [residual, g1, g2] = dynrbcirrineg_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 5, 1);

%
% Model equations
%

zkss__ = ((1/params(3)-1+params(2))/params(1))^(1/(params(1)-1));
ziss__ = params(2)*zkss__;
T39 = params(3)*exp(y(2))^(-params(4));
T49 = 1-params(2)+params(1)*exp(y(1))*exp(y(4))^(params(1)-1);
lhs =(-(exp(y(2))^(-params(4))))+T39*T49;
rhs =(-y(5))+y(5)*params(3)*(1-params(2));
residual(1)= lhs-rhs;
lhs =exp(y(2))+exp(y(4))-exp(y(4))*(1-params(2));
rhs =exp(y(1))*exp(y(4))^params(1);
residual(2)= lhs-rhs;
lhs =exp(y(3));
rhs =exp(y(4))-exp(y(4))*(1-params(2));
residual(3)= lhs-rhs;
lhs =y(3);
rhs =log(params(6)*ziss__);
residual(4)= lhs-rhs;
lhs =y(1);
rhs =y(1)*params(5)+x(1);
residual(5)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(5, 5);

  %
  % Jacobian matrix
  %

  g1(1,1)=T39*params(1)*exp(y(1))*exp(y(4))^(params(1)-1);
  g1(1,2)=(-(exp(y(2))*getPowerDeriv(exp(y(2)),(-params(4)),1)))+T49*params(3)*exp(y(2))*getPowerDeriv(exp(y(2)),(-params(4)),1);
  g1(1,4)=T39*params(1)*exp(y(1))*exp(y(4))*getPowerDeriv(exp(y(4)),params(1)-1,1);
  g1(1,5)=(-((-1)+params(3)*(1-params(2))));
  g1(2,1)=(-(exp(y(1))*exp(y(4))^params(1)));
  g1(2,2)=exp(y(2));
  g1(2,4)=exp(y(4))-exp(y(4))*(1-params(2))-exp(y(1))*exp(y(4))*getPowerDeriv(exp(y(4)),params(1),1);
  g1(3,3)=exp(y(3));
  g1(3,4)=(-(exp(y(4))-exp(y(4))*(1-params(2))));
  g1(4,3)=1;
  g1(5,1)=1-params(5);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],5,25);
end
end
