function [residual, g1, g2, g3] = usmodel_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           columns: equations in order of declaration
%                                                           rows: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(41, 1);
T21 = 1/(params(10)/(1-params(10)));
T37 = 1/(1+params(41)*params(39));
T45 = 1/(params(39)^2*params(12));
T57 = params(15)/params(39);
T62 = (1-T57)/(params(14)*(1+T57));
T74 = (1-params(13))/(params(44)+1-params(13));
T90 = (params(14)-1)*params(53)/(params(14)*(1+T57));
T120 = 1/(1-T57);
T123 = T57/(1-T57);
T212 = 1/(1+params(41)*params(39)*params(19));
T227 = (1-params(20))*(1-params(41)*params(39)*params(20))/params(20)/(1+(params(16)-1)*params(3));
T236 = params(41)*params(39)/(1+params(41)*params(39));
T264 = (1-params(18))*(1-params(41)*params(39)*params(18))/((1+params(41)*params(39))*params(18))*1/(1+(params(22)-1)*params(1));
lhs =y(52);
rhs =params(9)*y(31)+(1-params(9))*y(38);
residual(1)= lhs-rhs;
lhs =y(30);
rhs =y(31)*T21;
residual(2)= lhs-rhs;
lhs =y(31);
rhs =y(38)+y(37)-y(32);
residual(3)= lhs-rhs;
lhs =y(32);
rhs =y(30)+y(19);
residual(4)= lhs-rhs;
lhs =y(35);
rhs =T37*(y(4)+params(41)*params(39)*y(65)+T45*y(33))+y(55);
residual(5)= lhs-rhs;
lhs =y(33);
rhs =(-y(39))+y(53)*1/T62+params(44)/(params(44)+1-params(13))*y(62)+T74*y(63);
residual(6)= lhs-rhs;
lhs =y(34);
rhs =y(53)+T57/(1+T57)*y(3)+1/(1+T57)*y(64)+T90*(y(37)-y(66))-y(39)*T62;
residual(7)= lhs-rhs;
lhs =y(36);
rhs =y(34)*params(51)+y(35)*params(50)+y(54)+y(30)*params(52);
residual(8)= lhs-rhs;
lhs =y(36);
rhs =params(16)*(y(52)+params(9)*y(32)+(1-params(9))*y(37));
residual(9)= lhs-rhs;
lhs =y(38);
rhs =y(37)*params(21)+y(34)*T120-y(3)*T123;
residual(10)= lhs-rhs;
lhs =y(59);
rhs =y(19)*(1-params(46))+y(35)*params(46)+y(55)*params(39)^2*params(12)*params(46);
residual(11)= lhs-rhs;
lhs =y(40);
rhs =params(9)*y(42)+(1-params(9))*y(50)-y(52);
residual(12)= lhs-rhs;
lhs =y(41);
rhs =T21*y(42);
residual(13)= lhs-rhs;
lhs =y(42);
rhs =y(50)+y(48)-y(43);
residual(14)= lhs-rhs;
lhs =y(43);
rhs =y(41)+y(20);
residual(15)= lhs-rhs;
lhs =y(46);
rhs =y(55)+T37*(y(7)+params(41)*params(39)*y(70)+T45*y(44));
residual(16)= lhs-rhs;
lhs =y(44);
rhs =y(53)*1/T62+(-y(51))+y(72)+params(44)/(params(44)+1-params(13))*y(67)+T74*y(68);
residual(17)= lhs-rhs;
lhs =y(45);
rhs =y(53)+T57/(1+T57)*y(6)+1/(1+T57)*y(69)+T90*(y(48)-y(71))-T62*(y(51)-y(72));
residual(18)= lhs-rhs;
lhs =y(47);
rhs =y(54)+params(51)*y(45)+params(50)*y(46)+params(52)*y(41);
residual(19)= lhs-rhs;
lhs =y(47);
rhs =params(16)*(y(52)+params(9)*y(43)+(1-params(9))*y(48));
residual(20)= lhs-rhs;
lhs =y(49);
rhs =T212*(params(41)*params(39)*y(72)+params(19)*y(9)+y(40)*T227)+y(57);
residual(21)= lhs-rhs;
lhs =y(50);
rhs =T37*y(10)+T236*y(73)+y(9)*params(17)/(1+params(41)*params(39))-y(49)*(1+params(41)*params(39)*params(17))/(1+params(41)*params(39))+y(72)*T236+T264*(params(21)*y(48)+T120*y(45)-T123*y(6)-y(50))+y(58);
residual(22)= lhs-rhs;
lhs =y(61);
rhs =y(49)*params(23)*(1-params(26))+(1-params(26))*params(25)*(y(47)-y(36))+params(24)*(y(47)-y(36)-y(8)+y(5))+params(26)*y(11)+y(56);
residual(23)= lhs-rhs;
lhs =y(51);
rhs =y(61);
residual(24)= lhs-rhs;
lhs =y(52);
rhs =params(27)*y(12)+x(it_, 1);
residual(25)= lhs-rhs;
lhs =y(53);
rhs =params(29)*y(13)+x(it_, 2);
residual(26)= lhs-rhs;
lhs =y(54);
rhs =params(30)*y(14)+x(it_, 3)+x(it_, 1)*params(2);
residual(27)= lhs-rhs;
lhs =y(55);
rhs =params(32)*y(15)+x(it_, 4);
residual(28)= lhs-rhs;
lhs =y(56);
rhs =params(33)*y(16)+x(it_, 5);
residual(29)= lhs-rhs;
lhs =y(57);
rhs =params(34)*y(17)+y(29)-params(8)*y(2);
residual(30)= lhs-rhs;
lhs =y(29);
rhs =x(it_, 6);
residual(31)= lhs-rhs;
lhs =y(58);
rhs =params(35)*y(18)+y(28)-params(7)*y(1);
residual(32)= lhs-rhs;
lhs =y(28);
rhs =x(it_, 7);
residual(33)= lhs-rhs;
lhs =y(60);
rhs =(1-params(46))*y(20)+params(46)*y(46)+y(55)*params(12)*params(39)^2*params(46);
residual(34)= lhs-rhs;
lhs =y(24);
rhs =y(47)-y(8)+params(36);
residual(35)= lhs-rhs;
lhs =y(25);
rhs =params(36)+y(45)-y(6);
residual(36)= lhs-rhs;
lhs =y(26);
rhs =params(36)+y(46)-y(7);
residual(37)= lhs-rhs;
lhs =y(27);
rhs =params(36)+y(50)-y(10);
residual(38)= lhs-rhs;
lhs =y(23);
rhs =y(49)+params(5);
residual(39)= lhs-rhs;
lhs =y(22);
rhs =y(51)+params(37);
residual(40)= lhs-rhs;
lhs =y(21);
rhs =y(48)+params(4);
residual(41)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(41, 80);

  %
  % Jacobian matrix
  %

  g1(1,31)=(-params(9));
  g1(1,38)=(-(1-params(9)));
  g1(1,52)=1;
  g1(2,30)=1;
  g1(2,31)=(-T21);
  g1(3,31)=1;
  g1(3,32)=1;
  g1(3,37)=(-1);
  g1(3,38)=(-1);
  g1(4,30)=(-1);
  g1(4,32)=1;
  g1(4,19)=(-1);
  g1(5,33)=(-(T37*T45));
  g1(5,4)=(-T37);
  g1(5,35)=1;
  g1(5,65)=(-(params(41)*params(39)*T37));
  g1(5,55)=(-1);
  g1(6,62)=(-(params(44)/(params(44)+1-params(13))));
  g1(6,33)=1;
  g1(6,63)=(-T74);
  g1(6,39)=1;
  g1(6,53)=(-(1/T62));
  g1(7,3)=(-(T57/(1+T57)));
  g1(7,34)=1;
  g1(7,64)=(-(1/(1+T57)));
  g1(7,37)=(-T90);
  g1(7,66)=T90;
  g1(7,39)=T62;
  g1(7,53)=(-1);
  g1(8,30)=(-params(52));
  g1(8,34)=(-params(51));
  g1(8,35)=(-params(50));
  g1(8,36)=1;
  g1(8,54)=(-1);
  g1(9,32)=(-(params(9)*params(16)));
  g1(9,36)=1;
  g1(9,37)=(-((1-params(9))*params(16)));
  g1(9,52)=(-params(16));
  g1(10,3)=T123;
  g1(10,34)=(-T120);
  g1(10,37)=(-params(21));
  g1(10,38)=1;
  g1(11,35)=(-params(46));
  g1(11,55)=(-(params(39)^2*params(12)*params(46)));
  g1(11,19)=(-(1-params(46)));
  g1(11,59)=1;
  g1(12,40)=1;
  g1(12,42)=(-params(9));
  g1(12,50)=(-(1-params(9)));
  g1(12,52)=1;
  g1(13,41)=1;
  g1(13,42)=(-T21);
  g1(14,42)=1;
  g1(14,43)=1;
  g1(14,48)=(-1);
  g1(14,50)=(-1);
  g1(15,41)=(-1);
  g1(15,43)=1;
  g1(15,20)=(-1);
  g1(16,44)=(-(T37*T45));
  g1(16,7)=(-T37);
  g1(16,46)=1;
  g1(16,70)=(-(params(41)*params(39)*T37));
  g1(16,55)=(-1);
  g1(17,67)=(-(params(44)/(params(44)+1-params(13))));
  g1(17,44)=1;
  g1(17,68)=(-T74);
  g1(17,72)=(-1);
  g1(17,51)=1;
  g1(17,53)=(-(1/T62));
  g1(18,6)=(-(T57/(1+T57)));
  g1(18,45)=1;
  g1(18,69)=(-(1/(1+T57)));
  g1(18,48)=(-T90);
  g1(18,71)=T90;
  g1(18,72)=(-T62);
  g1(18,51)=T62;
  g1(18,53)=(-1);
  g1(19,41)=(-params(52));
  g1(19,45)=(-params(51));
  g1(19,46)=(-params(50));
  g1(19,47)=1;
  g1(19,54)=(-1);
  g1(20,43)=(-(params(9)*params(16)));
  g1(20,47)=1;
  g1(20,48)=(-((1-params(9))*params(16)));
  g1(20,52)=(-params(16));
  g1(21,40)=(-(T212*T227));
  g1(21,9)=(-(params(19)*T212));
  g1(21,49)=1;
  g1(21,72)=(-(params(41)*params(39)*T212));
  g1(21,57)=(-1);
  g1(22,6)=(-(T264*(-T123)));
  g1(22,45)=(-(T120*T264));
  g1(22,48)=(-(params(21)*T264));
  g1(22,9)=(-(params(17)/(1+params(41)*params(39))));
  g1(22,49)=(1+params(41)*params(39)*params(17))/(1+params(41)*params(39));
  g1(22,72)=(-T236);
  g1(22,10)=(-T37);
  g1(22,50)=1-(-T264);
  g1(22,73)=(-T236);
  g1(22,58)=(-1);
  g1(23,5)=(-params(24));
  g1(23,36)=(-((-((1-params(26))*params(25)))-params(24)));
  g1(23,8)=params(24);
  g1(23,47)=(-((1-params(26))*params(25)+params(24)));
  g1(23,49)=(-(params(23)*(1-params(26))));
  g1(23,11)=(-params(26));
  g1(23,56)=(-1);
  g1(23,61)=1;
  g1(24,51)=1;
  g1(24,61)=(-1);
  g1(25,12)=(-params(27));
  g1(25,52)=1;
  g1(25,74)=(-1);
  g1(26,13)=(-params(29));
  g1(26,53)=1;
  g1(26,75)=(-1);
  g1(27,14)=(-params(30));
  g1(27,54)=1;
  g1(27,74)=(-params(2));
  g1(27,76)=(-1);
  g1(28,15)=(-params(32));
  g1(28,55)=1;
  g1(28,77)=(-1);
  g1(29,16)=(-params(33));
  g1(29,56)=1;
  g1(29,78)=(-1);
  g1(30,2)=params(8);
  g1(30,29)=(-1);
  g1(30,17)=(-params(34));
  g1(30,57)=1;
  g1(31,29)=1;
  g1(31,79)=(-1);
  g1(32,1)=params(7);
  g1(32,28)=(-1);
  g1(32,18)=(-params(35));
  g1(32,58)=1;
  g1(33,28)=1;
  g1(33,80)=(-1);
  g1(34,46)=(-params(46));
  g1(34,55)=(-(params(12)*params(39)^2*params(46)));
  g1(34,20)=(-(1-params(46)));
  g1(34,60)=1;
  g1(35,24)=1;
  g1(35,8)=1;
  g1(35,47)=(-1);
  g1(36,25)=1;
  g1(36,6)=1;
  g1(36,45)=(-1);
  g1(37,26)=1;
  g1(37,7)=1;
  g1(37,46)=(-1);
  g1(38,27)=1;
  g1(38,10)=1;
  g1(38,50)=(-1);
  g1(39,23)=1;
  g1(39,49)=(-1);
  g1(40,22)=1;
  g1(40,51)=(-1);
  g1(41,21)=1;
  g1(41,48)=(-1);
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],41,6400);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],41,512000);
end
end
