function [zdata_check, new_guess, zdatass_, oo00_, M00_, switch_] = ...
    check_corner(modnam_00_,modnam_10_,modnam_01_,modnam_11_,...
    shockssequence_,irfshock_,nperiods_,violvecbool_check_vec,init_)




global M_ oo_



% solve model
eval(['dynare ',modnam_00_,' noclearall nolog'])
oo00_ = oo_;
M00_ = M_;


for i=1:M00_.endo_nbr
    eval([deblank(M00_.endo_names{i}) '_ss = oo00_.dr.ys(i); ']);
end

for i_indx_ = 1:M00_.param_nbr
    eval([M00_.param_names{i_indx_},'= M00_.params(i_indx_);']);
end



eval(['dynare ',modnam_10_,' noclearall'])
oo10_ = oo_;
M10_ = M_;

eval(['dynare ',modnam_01_,' noclearall'])
oo01_ = oo_;
M01_ = M_;

eval(['dynare ',modnam_11_,' noclearall'])
oo11_ = oo_;
M11_ = M_;


% do some error checking

% check inputs
if ~strcmp(M00_.endo_names,M10_.endo_names)
    error([modnam_00_,' and ',modnam_10_,' need to have exactly the same endogenous variables and they need to be declared in the same order'])
end

if ~strcmp(M00_.exo_names,M10_.exo_names)
    error([modnam_00_,' and ',modnam_10_,' need to have exactly the same exogenous variables and they need to be declared in the same order'])
end

if ~strcmp(M00_.param_names,M10_.param_names)
    warning(['The parameter list does not match across the files ',modnam_00_,' and ',modnam_10_])
end


if ~strcmp(M00_.endo_names,M01_.endo_names)
    error([modnam_00,' and ',modnam_01_,' need to have exactly the same endogenous variables and they need to be declared in the same order'])
end

if ~strcmp(M00_.exo_names,M01_.exo_names)
    error([modnam_00_,' and ',modnam_01_,' need to have exactly the same exogenous variables and they need to be declared in the same order'])
end

if ~strcmp(M00_.param_names,M01_.param_names)
    warning(['The parameter list does not match across the files ',modnam_00_,' and ',modnam_01_])
end


if ~strcmp(M00_.endo_names,M11_.endo_names)
    error([modnam_00_,' and ',modnam_11_,' need to have exactly the same endogenous variables and they need to be declared in the same order'])
end

if ~strcmp(M00_.exo_names,M11_.exo_names)
    error([modnam_00_,' and ',modnam_11_,' need to have exactly the same exogenous variables and they need to be declared in the same order'])
end

if ~strcmp(M00_.param_names,M11_.param_names)
    warning(['The parameter list does not match across the files ',modnam_00_,' and ',modnam_11_])
end





nvars_ = M00_.endo_nbr;
zdatass_ = oo00_.dr.ys;


[hm1_,h_,hl1_,Jbarmat_] = get_deriv(M00_,zdatass_);
cof_ = [hm1_,h_,hl1_];


M10_.params = M00_.params;
[hm1_,h_,hl1_,Jbarmat10_,resid_] = get_deriv(M10_,zdatass_);
cof10_ = [hm1_,h_,hl1_];
Dbarmat10_ = resid_;

M01_.params = M00_.params;
[hm1_,h_,hl1_,Jbarmat01_,resid_] = get_deriv(M01_,zdatass_);
cof01_ = [hm1_,h_,hl1_];
Dbarmat01_ = resid_;

M11_.params = M00_.params;
[hm1_,h_,hl1_,Jbarmat11_,resid_] = get_deriv(M11_,zdatass_);
cof11_ = [hm1_,h_,hl1_];
Dbarmat11_ = resid_;


if isfield(M00_,'nfwrd')  % needed for bakward compatibility with older Dynare releases
    [decrulea,decruleb]=get_pq(oo00_.dr,M00_);
else
    [decrulea,decruleb]=get_pq(oo00_.dr,M00_);
end
endog_ = M00_.endo_names;
exog_ =  M00_.exo_names;


if ~exist('init_','var')
    init_ = zeros(nvars_,1);
end
init_orig = init_;

if ~exist('maxiter_','var')
    maxiter_ = 20;
end





% set some initial conditions and loop through the shocks
% period by period
criterion_pos=strmatch('expected_profits',M00_.endo_names,'exact');
nshocks = size(shockssequence_,1);



violvecbool_= [violvecbool_check_vec; 0];
          
            
violvecbool_mat = [ [0;violvecbool_(1:end-1)] violvecbool_ ];
[regime_1, regimestart_1]=extended_map_regime(violvecbool_mat(:,1));
[regime_2, regimestart_2]=extended_map_regime(violvecbool_mat(:,2));

[zdata_check]=mkdatap_anticipated_2constraints(nperiods_,decrulea,decruleb,...
    cof_,Jbarmat_,...
    cof10_,Jbarmat10_,Dbarmat10_,...
    cof01_,Jbarmat01_,Dbarmat01_,...
    cof11_,Jbarmat11_,Dbarmat11_,...
    regime_1,regimestart_1,...
    regime_2,regimestart_2,...
    violvecbool_mat,endog_,exog_,...
    irfshock_,shockssequence_,init_);


[expand_left_switch, regime, regimestart, violvecbool_,new_guess]=expand_left_two_constraints(criterion_pos,nperiods_,decrulea,decruleb,...
                    cof_,Jbarmat_,...
                    cof10_,Jbarmat10_,Dbarmat10_,...
                    cof01_,Jbarmat01_,Dbarmat01_,...
                    cof11_,Jbarmat11_,Dbarmat11_,...
                    regime_2,regimestart_2,violvecbool_,...
                    endog_,exog_,...
                    irfshock_,shockssequence_,init_, zdata_check);
switch_= expand_left_switch;

