function [r_credit_gdp_emp_vec, shift] = ...
    function_corr_sensitivity_shifts(shift_lb, shift_ub, credit_series, gdp_series)

shift = [shift_lb:shift_ub]';
r_credit_gdp_emp_vec = zeros(length(shift),1);

for i=1:length(shift)
    credit_shifted_cyclical_emp = credit_series(1:end-shift(i));
    gdp_shifted_cyclical_emp = gdp_series (shift(i)+1:end);
    r_credit_gdp_emp = corrcoef(credit_shifted_cyclical_emp,gdp_shifted_cyclical_emp);
    r_credit_gdp_emp_vec(i) = r_credit_gdp_emp(1,2);
end

end