function [r_lb, r_up, r_emp, xconf, yconf, credit_shifted_cyclical_emp, gdp_emp_predicted] = ...
    function_shift_credit_conf_int(ltot_model_vec, ytot_model_vec, ltot_data, ytot_data, ...
    n_simul, shift, CI_level)

% Model

r_credit_gdp_vec = zeros(n_simul,1);
B_coeff_vec = zeros(n_simul,2);

for j=1:n_simul
    credit_shifted_cyclical = ltot_model_vec(j,1:end-shift);
    gdp_shifted_cyclical = ytot_model_vec(j,shift+1:end);
    r_credit_gdp=corrcoef(credit_shifted_cyclical,gdp_shifted_cyclical);
    r_credit_gdp_vec(j) = r_credit_gdp(1,2);
    
    yreg = gdp_shifted_cyclical';
    xreg = [0*credit_shifted_cyclical'+1 credit_shifted_cyclical'];
    %[Btot,BINTtot,Rtot,RINTtot,STATStot] = regress(yreg,xreg);
    B_coeff = regress(yreg,xreg);
    B_coeff_vec(j,:) = B_coeff'; 
end

r_lb = quantile(r_credit_gdp_vec,(1-CI_level)/2);
r_up = quantile(r_credit_gdp_vec,(1+CI_level)/2);


credit_shifted_cyclical_emp = ltot_data(1:end-shift);
gdp_shifted_cyclical_emp = ytot_data(shift+1:end);
r_credit_gdp_emp = corrcoef(credit_shifted_cyclical_emp,gdp_shifted_cyclical_emp);
r_emp = r_credit_gdp_emp(1,2);

credit_shifted_cyclical_emp_reg = ...
    [ones(size(credit_shifted_cyclical_emp,1),1) credit_shifted_cyclical_emp]';
reg_model_pred_vec = B_coeff_vec*credit_shifted_cyclical_emp_reg;

reg_lb = quantile(reg_model_pred_vec,(1-CI_level)/2);
reg_up = quantile(reg_model_pred_vec,(1+CI_level)/2);

%B_coeff_vec(:,1)+B_coeff_vec(:,2).*credit_shifted_cyclical_emp;

[credit_shifted_cyclical_emp_sort, I_sort] = sort(credit_shifted_cyclical_emp');
%credit_shifted_cyclical_emp_transpose = credit_shifted_cyclical_emp';
xconf = [credit_shifted_cyclical_emp_sort credit_shifted_cyclical_emp_sort(end:-1:1)] ;         
yconf = [reg_up(I_sort) reg_lb(I_sort(end:-1:1))];

% Empirics
yreg_emp = gdp_shifted_cyclical_emp;
xreg_emp = [0*credit_shifted_cyclical_emp+1 credit_shifted_cyclical_emp];
%[Btot,BINTtot,Rtot,RINTtot,STATStot] = regress(yreg,xreg);
B_coeff_emp = regress(yreg_emp,xreg_emp);
gdp_emp_predicted = B_coeff_emp'*...
    [ones(size(credit_shifted_cyclical_emp,1),1) credit_shifted_cyclical_emp]';


end