function maketable(mat,texfilename,columnlabels,rowlabels,sideways_switch,caption,column_precision)

if ~exist('sideways_switch','var')
sideways_switch = 0;
end
    

if ~exist('caption','var')
caption = '';
end

if ~exist('caption','var')
caption = '';
end

if sideways_switch
    header ={'\documentclass [12pt,fleqn] {article}';...
        '\usepackage{rotating}';...
        '\begin{document}'};

else
    header ={'\documentclass [12pt,fleqn] {article}';...
        '\begin{document}'};
end

table = tablelatex(mat,columnlabels,rowlabels,sideways_switch,caption,column_precision);

footer = {'\end{document}'};



document = [header;table;footer];
document = char(document);

nlines = size(document,1);

% save ascii file that contains the tex document
fid = fopen([deblank(texfilename),'.tex'],'w');
for i=1:nlines
    fprintf(fid,'%s \n',char(document(i,:)));
end
fclose(fid);

% 
eval(['!latex ',deblank(texfilename),'.tex'])
eval(['!dvips ',deblank(texfilename),'.dvi -o ',...
      deblank(texfilename),'.ps'])
