function table=tablelatex(resultmat,columnlabels,rowlabels,sideways_switch,caption,column_precision)

if ~exist('sideways_switch','var')
    sideways_switch = 0;
end

if ~exist('caption','var')
    caption = '';
end

if ~exist('column_precision','var')
    resultmat(:,1)*0+2;
end

nrows = size(resultmat,1);
ncols = size(resultmat,2);

if sideways_switch
    header = char('\begin{sidewaystable}','\center');
else
    header = char('\begin{table}','\center');
end
header = char(header,['\caption{',caption,'}']);
header = cellstr(header);

tabular = ['\begin{tabular}{|l|'];

for i=1:ncols
    tabular = [tabular,'c|'];
end
tabular = [tabular,'}'];

cellarray='';
for i=1:ncols
    cellarray=[cellarray,'&',columnlabels(i,:)];
end
cellarray = [cellarray,'\\'];


table = cellstr(header);
table = [table;cellstr(tabular);cellstr('\hline');cellstr(cellarray);cellstr('\hline')];
for i=1:nrows
    line = rowlabels(i,:);
    for j=1:ncols
        if (~isempty(strmatch('s.e.',rowlabels(i,:))))
            line = [line,'& (',num2str(resultmat(i,j),'%5.2f'),')'];   
        
        else 
            line = [line,'&',num2str(resultmat(i,j),['%5.',num2str(column_precision(j)),'f'])];   
        end
    end
    line = [line,'\\'];
    table = [table;cellstr(line)];
end
table = [table;cellstr('\hline')];

if sideways_switch
    footer = char('\end{tabular}','\end{sidewaystable}');
else
footer = char('\end{tabular}','\end{table}');
end
table = [table;cellstr(footer)];



